const os = require('os');
const fs = require('fs');
const http = require('http');
const qrimg = require('qr-image');
const express = require('express');
const rimraf = require('rimraf');
const moment = require('moment-timezone');
const bodyParser = require('body-parser');
const publicIp = require('ip');
const cors = require('cors');
const spintax = require('spintax');
const Boom = require('@hapi/boom');
const P = require('pino');
const app = express();
const axios = require('axios');
const server = http.createServer(app);
const { Server } = require("socket.io");
const config = require("./../config.js");
const Common = require("./common.js");
const Extend = require("./extend.js");
const cron = require('node-cron');
const NodeCache = require("node-cache")

const bulks = {};
const total_contacts = {};
const chatbots = {};
const limit_messages = {};
const stats_history = {};
const sessions = {};
const new_sessions = {};
const session_dir = __dirname + '/../sessions/';
let verify_next = 0;
let verify_response = false;
let verified = false;
let chatbot_delay = 1000;
let wa_version = '';
let retry_on_fail = {};


var CHATBOT_RESET_TIME = config.time_to_reset ?? 120;
let chatbot_latest_receive = moment().add(CHATBOT_RESET_TIME * 4, 'm');

const io = new Server(server, {
	cors: {
		origin: config.frontend,
	}
});

app.use(bodyParser.urlencoded({
	extended: true,
	limit: '50mb'
}));

app.use(bodyParser.json());


io.on('connection', (socket) => {
	console.log('new connection');
});

const Device = (os.platform() === 'win32') ? 'Windows' : (os.platform() === 'darwin') ? 'MacOS' : 'Linux'

const {
	default: makeWASocket,
	BufferJSON,
	useMultiFileAuthState,
	DisconnectReason,
	fetchLatestWaWebVersion,
	WAMessageStubType,
	Browsers,
	makeInMemoryStore,
	
	
	AnyMessageContent,
  BufferedEventData,
  
  CacheStore,
  Chat,
  ConnectionState,
  Contact,
  delay,
  
  downloadMediaMessage,
  
  generateWAMessageFromContent,
  getAggregateVotesInPollMessage,
  getContentType,
  getDevice,
  GroupMetadata,
  isJidBroadcast,
  isJidGroup,
  isJidUser,
  makeCacheableSignalKeyStore,
  MessageUpsertType,
  MiscMessageGenerationOptions,
  ParticipantAction,
  PHONENUMBER_MCC,
  prepareWAMessageMedia,
  proto,
  
  UserFacingSocketConfig,
  WABrowserDescription,
  WAMediaUpload,
  WAMessage,
  WAMessageUpdate,
  WAPresence,
  WASocket,
} = require('@adiwajshing/baileys')


var store = {};
var loggerBaileys = P({ timestamp: () => `,"time":"${new Date().toJSON()}"` }).child({})
loggerBaileys.level = "fatal";

var stores = {}

const WAZIPER = {
	io: io,
	app: app,
	server: server,
	sessions: sessions,
	chatbot_latest_receive: chatbot_latest_receive,
	cors: cors(config.cors),

	makeWASocket: async function (instance_id) {
		console.error('creating socket', instance_id, session_dir)

		const { state, saveCreds } = await useMultiFileAuthState(session_dir + instance_id);
		
		if (!stores[instance_id]) {
			stores[instance_id] = makeInMemoryStore({ logger: loggerBaileys });
		}

		const WA = makeWASocket({
			auth: state,
			printQRInTerminal: false,
			version: [2, 3000, 1020885143],
			browser: [Device, 'Chrome', '96.0.4664.110'],
			logger: P({ level: 'silent' }),
			receivedPendingNotifications: true,
			retryRequestDelayMs: 10,
			connectTimeoutMs: 60000,
			qrTimeout: 40000,
			defaultQueryTimeoutMs: undefined,
			emitOwnEvents: false,
			generateHighQualityLinkPreview: true,
			msgRetryCounterCache: new NodeCache(),
			userDevicesCache: new NodeCache(),
			transactionOpts: { maxCommitRetries: 10, delayBetweenTriesMs: 10 },
			/*patchMessageBeforeSending(message) {
			    if (message.deviceSentMessage?.message?.listMessage?.listType === proto.Message.ListMessage.ListType.PRODUCT_LIST) {
			        message = JSON.parse(JSON.stringify(message));
			        //message.deviceSentMessage.message.listMessage.listType = proto.Message.ListMessage.ListType.SINGLE_SELECT;
			        message.deviceSentMessage.message.listMessage = {
			            title: message.listMessage.title,
			            description: message.listMessage.description,
			            buttonText: message.listMessage.buttonText,
			            footerText: message.listMessage.footerText,
			            sections: message.listMessage.sections,
			            listType: proto.Message.ListMessage.ListType.SINGLE_SELECT
			        }
			        
			    }
			    if (message.listMessage?.listType == proto.Message.ListMessage.ListType.PRODUCT_LIST) {
			        message = JSON.parse(JSON.stringify(message));
			        //message.listMessage.listType = proto.Message.ListMessage.ListType.SINGLE_SELECT;
			        message.listMessage = {
			            title: message.listMessage.title,
			            description: message.listMessage.description,
			            buttonText: message.listMessage.buttonText,
			            footerText: message.listMessage.footerText,
			            sections: message.listMessage.sections,
			            listType: proto.Message.ListMessage.ListType.SINGLE_SELECT
			        }
			        
			    }
			    
			    
			    console.log(message)
			    return message;
			},*/
		});

		await WA.ev.on('connection.update', async ({ connection, lastDisconnect, isNewLogin, qr, receivedPendingNotifications }) => {
			/*
			* Get QR COde
			*/
			if (qr != undefined) {
				WA.qrcode = qr;
				if (new_sessions[instance_id] == undefined)
					new_sessions[instance_id] = new Date().getTime() / 1000 + 300;
			}

			/*
			* Login successful
			*/
			if (isNewLogin) {

				/*
				* Reload session after login successful
				*/
				await WAZIPER.makeWASocket(instance_id);

			}

			if (lastDisconnect != undefined && lastDisconnect.error != undefined) {
				var statusCode = lastDisconnect.error.output.statusCode;
				if (DisconnectReason.restartRequired == statusCode || DisconnectReason.connectionClosed == statusCode) {
					await WAZIPER.makeWASocket(instance_id);
				}
			}

			/*
			* Connection status
			*/
			switch (connection) {
				case "close":
					/*
					* 401 Unauthorized
					*/
					if (lastDisconnect.error != undefined) {
						var statusCode = lastDisconnect.error.output.statusCode;
						if (DisconnectReason.loggedOut == statusCode || 0 == statusCode) {
							var SESSION_PATH = session_dir + instance_id;
							if (fs.existsSync(SESSION_PATH)) {
								rimraf.sync(SESSION_PATH);
								delete sessions[instance_id];
								delete chatbots[instance_id];
								delete bulks[instance_id];
							}

							await WAZIPER.session(instance_id);
						}
					}
					break;

				case "open":
					// Reload WASocket
					if (WA.user.name == undefined) {
						WA.user.name = WA.user?.id ? Common.get_phone(WA.user?.id, "wid") : instance_id;
					}

					sessions[instance_id] = WA;

					// Remove QR code
					//if (sessions[instance_id].qrcode != undefined) {
					console.log('remove new session qr')
					delete sessions[instance_id].qrcode;
					delete new_sessions[instance_id];
					//}

					// Add account
					var session = await Common.db_get("sp_whatsapp_sessions", [{ instance_id: instance_id }, { status: 0 }]);
					if (session) {
						// Get avatar 
						WA.user.avatar = await WAZIPER.get_avatar(WA);

						var account = await Common.db_get("sp_accounts", [{ token: instance_id }]);
						if (!account) {
							account = await Common.db_get("sp_accounts", [{ pid: Common.get_phone(WA.user.id, "wid") }, { team_id: session.team_id }]);
						}

						await Common.update_status_instance(instance_id, WA.user);
						await WAZIPER.add_account(instance_id, session.team_id, WA.user, account);
						await Common.update_creds(WA, instance_id, WA.user);
					}

					WA.store = stores[instance_id];
					stores[instance_id].bind(WA.ev);
					WA.ev.flush();

					break;

				default:
				// code block
			}
		});

		await WA.ev.on('messages.upsert', async (messages) => {
			WAZIPER.webhook(instance_id, { event: "messages.upsert", data: messages });

			//console.log(messages.type);
			//* LIVECHAT FUNCTION
			if ((config['extended_functions'] ?? true)) {
				Extend.chat.processChatMessages(WAZIPER, sessions, messages, instance_id);
			}
			//* END LIVECHAT FUNCTION
			if (messages.messages != undefined && messages.type == 'notify' || messages.messages != undefined && messages.type == 'append') {
				messages = messages.messages;

				if (messages.length > 0) {
					for (var i = 0; i < messages.length; i++) {
						var message = messages[i];
						var chat_id = message.key.remoteJid;

						if (message.key.fromMe === true && message.key.remoteJid != "status@broadcast" && message.message != undefined) {
							var user_type = "user";

							if (chat_id.indexOf("s.whatsapp.net") === -1) {
								user_type = "group";
							}

							try {
								await Extend.disableBotKeyword(WAZIPER, instance_id, user_type, message);
							} catch (error) {
								//console.error(error);
							}
						}


						if (message.key.fromMe === false && message.key.remoteJid != "status@broadcast" && message.message != undefined) {
							var user_type = "user";

							if (chat_id.indexOf("s.whatsapp.net") === -1) {
								user_type = "group";
							} else {
								console.log('incomming message', user_type, instance_id, chat_id);
							}

							WAZIPER.chatbot(instance_id, user_type, message);
							await Common.sleep(1000);
							WAZIPER.autoresponder(instance_id, user_type, message);
						} else if (message.key.remoteJid != "status@broadcast" && message.messageStubType != undefined && message.messageStubType == WAMessageStubType.CIPHERTEXT) {
							//console.error({ key: message.key, params: message.messageStubParameters }, 'failure in decrypting message');

							var user_type = "user";

							if (chat_id.indexOf("g.us") !== -1) {
								user_type = "group";
							}

							var item = await Common.db_get("sp_whatsapp_fail_decode_message", [{ instance_id: instance_id }, { status: 1 }]);

							if (item) {
								if (user_type == "user") {
									await WAZIPER.auto_send(instance_id, chat_id, chat_id, "faildecode", item, false, message, false, function (result) { });
								}
							} else {
								//await WAZIPER.autoresponder(instance_id, user_type, message);
							}
						}

						//Add Groups for Export participants
						if (message.message != undefined) {
							if (chat_id.includes("@g.us")) {
								if (sessions[instance_id].groups == undefined) {
									sessions[instance_id].groups = [];
								}

								var newGroup = true;
								sessions[instance_id].groups.forEach(async (group) => {
									if (group.id == chat_id) {
										newGroup = false;
									}
								});

								if (newGroup) {
									await WA.groupMetadata(chat_id).then(async (group) => {
										sessions[instance_id].groups.push({ id: group.id, name: group.subject, size: group.size, desc: group.desc, participants: group.participants });
									}).catch((err) => { });
								}
							}
						}


					}
				}
			}
		});

		await WA.ev.on('contacts.update', async (contacts) => {
			WAZIPER.webhook(instance_id, { event: "contacts.update", data: contacts });
		});

		await WA.ev.on('contacts.upsert', async (contacts) => {
			WAZIPER.webhook(instance_id, { event: "contacts.upsert", data: contacts });
		});

		await WA.ev.on('messages.update', async (messages) => {
			WAZIPER.webhook(instance_id, { event: "messages.update", data: messages });
		});
		
		WA.ev.on('call', async (call) => {
			WAZIPER.webhook(instance_id, { event: "call", data: call });
			await WAZIPER.callresponder(instance_id, call);
			
		});

		await WA.ev.on('groups.update', async (group) => {
			WAZIPER.webhook(instance_id, { event: "groups.update", data: group });
		});

		await WA.ev.on('creds.update', saveCreds);

		return WA;
	},

	session: async function (instance_id, reset) {
		if (sessions[instance_id] == undefined || reset) {
			sessions[instance_id] = await WAZIPER.makeWASocket(instance_id);
		}

		return sessions[instance_id];
	},

	instance: async function (access_token, instance_id, res, callback, reset = false) {
		var time_now = Math.floor(new Date().getTime() / 1000);

		if (instance_id == undefined && res != undefined) {
			if (res) {
				return res.json({ status: 'error', message: "The Instance ID must be provided for the process to be completed" });
			} else {
				console.error(instance_id, "The Instance ID must be provided for the process to be completed");
				return callback(false);
			}
		}

		var team = await Common.db_get("sp_team", [{ ids: access_token }]);

		if (!team) {
			if (res) {
				return res.json({ status: 'error', message: "The authentication process has failed" });
			} else {
				console.error(instance_id, "The authentication process has failed");
				// return callback(false);
			}
		}

		var account = await Common.db_get("sp_accounts", [{ token: instance_id }, { team_id: team.id }]);

		if (account && account.login_type == 1) {
			return callback(account);
		}

		var session = await Common.db_get("sp_whatsapp_sessions", [{ instance_id: instance_id }, { team_id: team.id }]);
		if (!session) {
			console.log('no record found on sp_whatsapp_sessions', instance_id, team.id);
			// Common.db_update("sp_accounts", [{ status: 0 }, { token: instance_id }]);
			if (res) {
				return res.json({ status: 'error', message: "The Instance ID provided has been invalidated" });
			} else {
				console.error(instance_id, "The Instance ID provided has been invalidated");
				return callback(false);
			}
		}

		sessions[instance_id] = await WAZIPER.session(instance_id, reset);
		return callback(sessions[instance_id]);
	},

	webhook: async function (instance_id, data) {
		var tb_webhook = await Common.db_query("SHOW TABLES LIKE 'sp_whatsapp_webhook'");
		if (tb_webhook) {
			var webhook = await Common.db_query("SELECT * FROM sp_whatsapp_webhook WHERE status = 1 AND instance_id = '" + instance_id + "'");
			if (webhook) {
				webhook.allowed_events = webhook.allowed_events ?? '';
				if (webhook.allowed_events == '' || webhook.allowed_events.includes(data.event)) {
					//console.log('trigger webhook', instance_id, data.event);
					axios.post(webhook.webhook_url, { instance_id: instance_id, data: data }).then((res) => { }).catch((err) => { });
				}
			}
		}
	},

	get_qrcode: async function (instance_id, res) {
		var client = sessions[instance_id];
		if (client == undefined) {
			return res.json({ status: 'error', message: "The WhatsApp session could not be found in the system" });
		}

		if (client.qrcode != undefined && !client.qrcode) {
			return res.json({ status: 'error', message: "It seems that you have logged in successfully" });
		}

		//Check QR code exist
		for (var i = 0; i < 10; i++) {
			if (client.qrcode == undefined) {
				await Common.sleep(1000);
			}
		}

		if (client.qrcode == undefined || client.qrcode == false) {
			return res.json({ status: 'error', message: "The system cannot generate a WhatsApp QR code" });
		}

		var code = qrimg.imageSync(client.qrcode, { type: 'png' });
		return res.json({ status: 'success', message: 'Success', base64: 'data:image/png;base64,' + code.toString('base64') });
	},
	
	get_pairing: async function (instance_id, req, res) {
	    var client = sessions[instance_id];
		if (client == undefined) {
			return res.json({ status: 'error', message: "The WhatsApp session could not be found in the system" });
		}

		if (client.authState.creds.registered) {
			return res.json({ status: 'error', message: "It seems that you have logged in successfully" });
		}
		
		if (!(client.authState.creds.registered && (client.user || {}).id) && client.qrcode != undefined) {
		    let phoneNumber = req.query.phone;
		    phoneNumber = phoneNumber.replace(/\D/g, '')
		    client.paircode = await client.requestPairingCode(phoneNumber)
		    console.log('Pairing code:', (client.paircode.match(/.{1,4}/g)).join('-'))
		}

		//Check QR code exist
		for (var i = 0; i < 10; i++) {
			if (client.paircode == undefined) {
				await Common.sleep(1000);
			}
		}

		if (client.paircode == undefined  && client.qrcode == undefined || client.paircode == false && client.qrcode == false) {
			return res.json({ status: 'error', message: "The system cannot generate a WhatsApp Pairing code" });
		}
		
		return res.json({ status: 'success', message: 'Success', code: client.paircode.match(/.{1,4}/g).join('-') });
	},

	get_info: async function (instance_id, res) {
		var client = sessions[instance_id];
		if (client != undefined && client.user != undefined) {
			if (client.user.avatar == undefined) await Common.sleep(1500);
			client.user.avatar = await WAZIPER.get_avatar(client);
			return res.json({ status: 'success', message: "Success", data: client.user });
		} else {
			return res.json({ status: 'error', message: "Error", relogin: true });
		}
	},

	get_avatar: async function (client) {
		try {
			const ppUrl = await client.profilePictureUrl(client.user.id);
			return ppUrl;
		} catch (e) {
			return Common.get_avatar(client.user.name);
		}
	},

	relogin: async function (instance_id, res) {
		if (sessions[instance_id]) {
			var readyState = await WAZIPER.waitForOpenConnection(sessions[instance_id].ws);
			if (readyState === 1) {
				sessions[instance_id].end();
			}

			delete sessions[instance_id];
			delete chatbots[instance_id];
			delete bulks[instance_id];
		}

		await WAZIPER.session(instance_id, true);
	},

	logout: async function (instance_id, res) {
		Common.db_delete("sp_whatsapp_sessions", [{ instance_id: instance_id }]);
		Common.db_update("sp_accounts", [{ status: 0 }, { token: instance_id }]);

		if (sessions[instance_id]) {
			if (typeof sessions[instance_id].ws._events.close === "function") {
				sessions[instance_id].ws._events.close();
			}

			var SESSION_PATH = session_dir + instance_id;
			if (fs.existsSync(SESSION_PATH)) {
				rimraf.sync(SESSION_PATH);
			}
			delete sessions[instance_id];
			delete chatbots[instance_id];
			delete bulks[instance_id];

			if (res != undefined) {
				return res.json({ status: 'success', message: 'Success' });
			}
		} else {
			if (res != undefined) {
				return res.json({ status: 'error', message: 'This account seems to have logged out before.' });
			}
		}
	},

	get_groups: async function (instance_id, res) {
		var client = sessions[instance_id];
		if (client != undefined && client.groups != undefined) {
			res.json({ status: 'success', message: 'Success', data: client.groups });
		} else {
			res.json({ status: 'success', message: 'Success', data: [] });
		}
	},

	bulk_messaging: async function () {

		const d = new Date();
		var time_now = parseInt(d.getTime() / 1000);

		console.log('bulk process check', time_now);

		var query = `SELECT * FROM sp_whatsapp_schedules WHERE status = 1 AND run <= '${time_now}' AND accounts != '' AND time_post <= '${time_now}' ORDER BY time_post ASC LIMIT 50`;
		items = await Common.db_query(query, false);


		if (items) {
			console.log('bulk process check items', items.length);

			items.forEach(async (item) => {
				await Common.db_update("sp_whatsapp_schedules", [{ run: time_now + 300 }, { id: item.id }]);
			});

			items.forEach(async (item) => {

				console.log('bulk process', item.id, 'next account', item.next_account);
				//Get current hour
				var current_hour = -1;
				if (item.timezone != "") {
					var user_diff = Common.getTZDiff(item.timezone);
					var now = moment();
					current_hour = parseInt(now.tz(item.timezone).format('HH'));
				}

				//Process next hour
				if (item.schedule_time != "" && current_hour != -1) {
					var schedule_time = JSON.parse(item.schedule_time);
					if (!schedule_time.includes(current_hour.toString())) {
						var next_time = -1;

						for (var i = 1; i <= 24; i++) {
							var now_ = moment();
							var hour = parseInt(now_.tz(item.timezone).add(i, 'hours').format('HH'));
							if (schedule_time.includes(hour.toString())) {
								var minutes = new Date(time_now * 1000).getMinutes();
								var max_minute_rand = (minutes > 10) ? 10 : minutes;
								var random_add_minutes = Common.randomIntFromInterval(0, max_minute_rand);
								next_time = d.getTime() / 1000 + i * 60 * 60 - ((minutes - random_add_minutes) * 60);
								break;
							}
						}

						if (next_time == -1) {
							await Common.db_update("sp_whatsapp_schedules", [{ status: 2 }, { id: item.id }]);
						} else {
							await Common.db_update("sp_whatsapp_schedules", [{ time_post: next_time }, { id: item.id }]);
						}
						return false;
					}
				}


				if (!item.result) {
					console.log('restarting counters for ', item.id);
					var query_phone_data = '';
					if (!bulks[item.id]) {
						bulks[item.id] = {};
					}
					bulks[item.id]['bulk_sent'] = 0;
					bulks[item.id]['bulk_failed'] = 0;
				} else {
					result = JSON.parse(item.result);
					var query_phone_data = [];
					for (var i = 0; i < result.length; i++) {
						query_phone_data.push(result[i].phone_number.toString());
					}
				}


				console.log('bulk continue bulk');
				var params = false;
				var phone_number_item = await Common.get_phone_number(item.contact_id, query_phone_data);
				if (!phone_number_item) {
					//Complete
					await Common.db_update("sp_whatsapp_schedules", [{ status: 2, run: 0 }, { id: item.id }]);

					WAZIPER.io.emit('end_campaign_' + item.team_id, {
						id: item.id,
						status: 2
					});

					return false;
				} else {
					phone_number = `${phone_number_item.phone}`.replaceAll('.00', '');
					params = phone_number_item.params;
				}

				//Random account
				var instance_id = false;
				var accounts = JSON.parse(item.accounts);
				var next_account = item.next_account;


				// TODO: estó se puede optimizar, primero se deberia traer solo las cuentas con status 1, y a partir de ahu contar, se podria eliminar el foreach

				if (next_account == null || next_account == "" || next_account > accounts.length - 1) next_account = 0;

				var check_account = await Common.get_accounts(accounts.join(","));
				if (check_account && check_account.count == 0) {
					console.log('no accounts');
					await Common.db_update("sp_whatsapp_schedules", [{ status: 0 }, { id: item.id }]);
				}

				await accounts.forEach(async (account, index) => {
					if (!instance_id && index == next_account) {
						var account_item = await Common.db_get("sp_accounts", [{ id: account }, { status: 1 }]);

						if (account_item) instance_id = account_item.token;



						phone_number = `${phone_number_item.phone}`.replaceAll('.00', '');
						params = phone_number_item.params;
						if (phone_number.indexOf("g.us") !== -1) {
							var chat_id = phone_number;
						} else {
							phone_number = await Common.check_especials(phone_number);
							var chat_id = parseInt(phone_number) + "@c.us";
						}

						if (account_item && account_item.team_id == phone_number_item.team_id) {


							if (account_item.login_type != 1 && sessions[instance_id] == undefined) {
								Common.db_update("sp_whatsapp_schedules", [{ next_account: next_account + 1, run: 1 }, { id: item.id }]);
							} else {

								await WAZIPER.auto_send(instance_id, chat_id, phone_number, "bulk", item, phone_number_item, false, false, async function (result) {
									if (result.stats && result.type == "bulk") {
										var status = result.status;
										var new_stats = { phone_number: result.phone_number, status: status };
										if (item.result == null || item.result == "") {
											var result_list = [new_stats];
										} else {
											var result_list = JSON.parse(item.result);
											result_list.push(new_stats);
										}

										if (bulks[item.id] == undefined) {
											bulks[item.id] = {};
										}

										if (
											bulks[item.id].bulk_sent == undefined &&
											bulks[item.id].bulk_failed == undefined
										) {
											bulks[item.id].bulk_sent = item.sent;
											bulks[item.id].bulk_failed = item.failed;
										}

										bulks[item.id].bulk_sent += (status ? 1 : 0);
										bulks[item.id].bulk_failed += (!status ? 1 : 0);

										//Total sent & failed
										var total_sent = bulks[item.id].bulk_sent;
										var total_failed = bulks[item.id].bulk_failed;
										var total_complete = total_sent + total_failed;

										//Next time post
										var now = Math.floor(new Date().getTime() / 1000);
										var random_time = Math.floor(Math.random() * item.max_delay) + item.min_delay;
										var next_time = item.time_post + random_time;
										if (next_time < now) {
											next_time = now + random_time;
										}

										var data = {
											result: JSON.stringify(result_list),
											sent: total_sent,
											failed: total_failed,
											time_post: next_time,
											next_account: next_account + 1,
											run: 0,
										};


										await Common.db_update("sp_whatsapp_schedules", [data, { id: item.id }]);

										var total_phone_numbers = await Common.get_total_phone_number(item.contact_id);
										WAZIPER.io.emit('update_campaign_' + item.team_id, {
											id: item.id,
											sent: total_sent,
											failed: total_failed,
											next: next_time,
											total_phone_numbers: total_phone_numbers.count
										});
									}
								});
							}
						}
					}
				});

			});
		}
	},
	
	autoresponder: async function(instance_id, user_type, message){
            var chat_id = message.key.remoteJid;
            var now = new Date().getTime() / 1000;
            var item = await Common.db_get("sp_whatsapp_autoresponder", [{ instance_id: instance_id }, { status: 1 }]);
           // console.log("MENSAGEM RECEBIDA:", message);
            //    console.log("Conte do de contextInfo:", message.contextInfo);

        
            //item.delay = 1; // TESTE APENAS - Ajuste o valor para o n mero desejado em minutos
        
            if (!item) {
                return false;
            }
        
            //Accept sent to all/group/user
            switch (item.send_to) {
                case 2:
                    if (user_type == "group") return false;
                    break;
                case 3:
                    if (user_type == "user") return false;
                    break;
            }
            
            //Except contacts
            var except_data = [];
            if (item.except != null) {
                var except_data = item.except.split(",");;
            }
            
            //console.log("Contatos Exclu dos:", except_data);
        
            if (except_data.length > 0) {
                for (var i = 0; i < except_data.length; i++) {
                    if (except_data[i] != "" && chat_id.indexOf(except_data[i]) != -1) {
                        console.log("Contato exclu do. N o enviando resposta autom tica.");
                        return false;
                    }
                }
            }
                    
            //EDITED G3
            var idConversa = message.key.id;
            var participanteGrupo = message.key.participant;
        
            //nextAction, inputName e saveData
            var saveData = '';
            var inputName = '';
            var nextAction = '';
        
            //EDITED G3 - Acessar o texto da mensagem
            var msgConversa = '';
            if (chat_id.length >= 16) {
                msgConversa = message.message.conversation || '';
            } else {
                msgConversa = message.message.extendedTextMessage.text || '';
            }
            
            //Definir a mensagem recebida
            const msgRecebida = msgConversa;
            //EDITED G3 - Obter o nome definido pelo contato no WhatsApp
            const waName = message.pushName || '';
            var cleanedWaName = waName.replace(/[&<>"']/g, '');
    
            // Substituir as vari veis no corpo da requisi  o
            item.caption = item.caption.replace('%msg_recebida%', msgRecebida)
                            .replace('%wa_nome%', cleanedWaName)
                            .replace('%wa_numero%', userPhone);
            //console.log("nome wa:", message.pushName);
            //console.log("Dados MSG:", item.caption);
        
            // Obter o n mero de telefone do contato
            var userPhone = message.key.remoteJid.split('@')[0];
                console.log("DADOS RR:" , userPhone);
            // Verificar se h  um registro na tabela para este n mero
            
            var whereClause = [{ whatsapp: userPhone} , {instance_id: instance_id }];
            //var items = await Common.db_fetch("sp_whatsapp_chatbot", [ { instance_id: instance_id }, { status: 1 }, { run: 1 } ]);
            
            var responseRecord = await Common.db_fetch("sp_whatsapp_ar_responses", [{ whatsapp: userPhone} , {instance_id: instance_id }]);
                //console.log("WHEREClause:", whereClause);
                //console.log("RR:", responseRecord);
        
            // ...

            if (responseRecord) {
                // Calcular o tempo decorrido desde a  ltima resposta
                var timeElapsed = now - new Date(responseRecord[0].last_response).getTime() / 1000;
            
                // Verificar se j  passou o tempo definido em delay
                if (timeElapsed < item.delay * 60) {
                    //console.log("Proxima intera  o:", item.delay);
                    console.log("Tempo ainda n o passou. Aguardando...");
                    return false; // N o enviar a resposta autom tica se o tempo n o tiver passado
                }
            } else {
                // Se n o existir, crie um novo registro
                var newRecord = {
                    whatsapp: userPhone,
                    instance_id: instance_id,
                    last_response: new Date(),
                    // Adicione outras colunas e valores necess rios
                };
            
                // Insira o novo registro no banco de dados
                await Common.db_insert("sp_whatsapp_ar_responses", newRecord);
            
               // console.log("Novo registro criado:", newRecord);
            
                // Debugging: Adicione logs para verificar se a l gica de envio de mensagem est  sendo alcan ada
                //console.log("Enviando a resposta autom tica...");
                await sessions[instance_id].sendPresenceUpdate('composing', chat_id);
            
                setTimeout(async function () {
                    await WAZIPER.auto_send(instance_id, chat_id, chat_id, "autoresponder", item, false, false, function(result) {
                        console.log("Resultado do envio 1:", result);
                        // L gica de envio da resposta autom tica
                        
                    });
                }, 10000);
                await sessions[instance_id].sendPresenceUpdate('available', chat_id);
            
                console.log("Resposta autom tica enviada para ", userPhone);
            }
            
        
            //END EDITED
                   
             // Delay response
            var userPhone = message.key.remoteJid.split('@')[0];
            var whereClause = [{ whatsapp: userPhone} , {instance_id: instance_id }];
            //var items = await Common.db_fetch("sp_whatsapp_chatbot", [ { instance_id: instance_id }, { status: 1 }, { run: 1 } ]);
            
            var responseRecord = await Common.db_fetch("sp_whatsapp_ar_responses", [{ whatsapp: userPhone} , {instance_id: instance_id }]);
                //console.log("WHEREClause 2:", whereClause);
                //console.log("RR 2:", responseRecord);
        
            // ...

            if (responseRecord) {
                // Calcular o tempo decorrido desde a  ltima resposta
                var timeElapsed = now - new Date(responseRecord[0].last_response).getTime() / 1000;
            
                // Verificar se j  passou o tempo definido em delay
                if (timeElapsed < item.delay * 60) {
                    //console.log("Proxima intera  o:", item.delay);
                    console.log("Tempo ainda n o passou. Aguardando...");
                    return false; // N o enviar a resposta autom tica se o tempo n o tiver passado
                }
            } else {
                // Se n o existir, crie um novo registro
                var newRecord = {
                    whatsapp: userPhone,
                    instance_id: instance_id,
                    last_response: new Date(),
                    // Adicione outras colunas e valores necess rios
                };
            
                // Insira o novo registro no banco de dados
                await Common.db_insert("sp_whatsapp_ar_responses", newRecord);
            
               // console.log("Novo registro criado:", newRecord);
            
                // Debugging: Adicione logs para verificar se a l gica de envio de mensagem est  sendo alcan ada
                //console.log("Enviando a resposta autom tica...");
            
                await WAZIPER.auto_send(instance_id, chat_id, chat_id, "autoresponder", item, false, false, function(result) {
                    console.log("Resultado do envio:", result);
                    // L gica de envio da resposta autom tica
                });
            
                console.log("Resposta autom tica enviada para ", userPhone);
            }
        
            // Agrupa os par metros em um objeto
            const msg_info = {
                cleanedWaName: cleanedWaName,
                userPhone: userPhone,
                idConversa: idConversa,
                msgConversa: msgConversa,
                participanteGrupo: participanteGrupo,
                nextAction: nextAction,
                inputName: inputName,
                saveData: saveData
            };
        
            // Atualizar ou inserir o registro na tabela com o novo timestamp
            var updateData = { last_response: new Date() };
            var whereClause = { whatsapp: userPhone, instance_id: instance_id };
        
            // Adicione esta fun  o dentro do mesmo escopo que autoresponder
            async function updateOrInsert(table, updateData, whereClause) {
                //console.log("whereClause2:", whereClause2);
                var existingRecord = await Common.db_fetch(table, whereClause);
                //console.log("DB_fetch:", existingRecord);
            
                if (existingRecord && existingRecord.length > 0) {
                    // Se o registro existir, atualizar
                    var matchingRecord = existingRecord.find(record => 
                        record.whatsapp === whereClause.whatsapp && record.instance_id === whereClause.instance_id
                    );
            
                    if (matchingRecord) {
                        // Se o registro existir, atualizar
                        console.log("Registro existente. Atualizando...");
            
                        // Obter o ID do registro existente
                        var id = matchingRecord.id;
                        console.log("ID CONTATO:", id);
            
                        var dataUp = {
                            last_response: new Date(),
                            // Adicione outras colunas e valores que deseja atualizar
                        };
            
                        // Atualizar com base no ID
                        var res = await Common.db_update(table, [dataUp, { id: id }]);
                        console.log("Resultado da atualiza  o:", res);
                        return res;
                    } else {
                        console.log("Registro n o encontrado para atualiza  o.");
                        // Se o registro n o for encontrado, voc  pode optar por inserir um novo registro aqui
                        // var res = await Common.db_insert(table, { ...updateData, ...whereClause });
                        // console.log("Resultado da inser  o:", res);
                        // return res;
                    }
                } else {
                    // Se o registro n o existir, inserir
                    console.log("Registro n o existente. Inserindo...");
                    var res = await Common.db_insert(table, { ...updateData, ...whereClause });
                    console.log("Resultado da inser  o:", res);
                    return res;
                }
            }


        
            // Verificar se o registro j  existe
            var existingRecord = await Common.db_fetch("sp_whatsapp_ar_responses", whereClause);
        
            if (existingRecord) {
                // Se o registro existir, atualizar
                await updateOrInsert("sp_whatsapp_ar_responses", updateData, whereClause);
            } else {
                // Se o registro n o existir, inserir
                await updateOrInsert("sp_whatsapp_ar_responses", { ...updateData, ...whereClause });
            }
        
            //ENVIAR SE TIVER PASSADO TEMPO
            console.log("Tempo passou. Enviando a resposta autom tica...");
            await sessions[instance_id].sendPresenceUpdate('composing', chat_id);
            await WAZIPER.auto_send(instance_id, chat_id, chat_id, "autoresponder", item, false, false, function(result) {
                //console.log('Resultado AR 3:', result);
                // L gica de envio da resposta autom tica
            });
            await sessions[instance_id].sendPresenceUpdate('available', chat_id);
            return false;
        },

	/*autoresponder: async function (instance_id, user_type, message) {
		var chat_id = message.key.remoteJid;
		var tz = await Extend.getAccountTimezone(instance_id);
		var now = new Date().getTime().toLocaleString('en-US', {
		    timeZone: tz
		});
		now = now.split(",");
		now = now[0] + now[1] + now[2] + now[3];
		var item = await Common.db_get("sp_whatsapp_autoresponder", [{ instance_id: instance_id }, { status: 1 }]);
		if (!item) {
			return false;
		}

		//Accept sent to all/group/user
		switch (item.send_to) {
			case 2:
				if (user_type == "group") return false;
				break;
			case 3:
				if (user_type == "user") return false;
				break;
		}

		var check_autoresponder = await Extend.autoresponder_time(message, instance_id, chat_id);

		if (check_autoresponder && check_autoresponder + item.delay * 60 >= now) {
			return false;
		}

		//Except contacts
		var except_data = [];
		if (item.except != null) {
			var except_data = item.except.split(",");;
		}

		if (except_data.length > 0) {
			for (var i = 0; i < except_data.length; i++) {
				if (except_data[i] != "" && chat_id.indexOf(except_data[i]) != -1) {
					return false;
				}
			}
		}

		await WAZIPER.auto_send(instance_id, chat_id, chat_id, "autoresponder", item, false, message, false, function (result) { });
		return false;
	},*/
	
	callresponder: async function (instance_id, call) {
		var chat_id = call[0].from;
		var now = new Date().getTime() / 1000;
		var calltime = new Date(+call.date * 1000);
		var call_item = await Common.db_get("sp_whatsapp_callresponder", [{ instance_id: instance_id }, { status: 1 }]);
		
		if (!call_item) {
			return false;
		}
		
		

		if(sessions[instance_id].lastCall == undefined){
    		sessions[instance_id].lastCall = {};
    	}

    	var check_autoresponder = sessions[instance_id].lastCall[chat_id];
    	sessions[instance_id].lastCall[chat_id] = calltime / 1000;
    	
    	if (check_autoresponder && check_autoresponder + item.delay * 60 >= now) {
			return false;
		}

		//Except contacts
		var except_data = [];
		if (call_item.except != null) {
			var except_data = call_item.except.split(",");
		}

		if (except_data.length > 0) {
			for (var i = 0; i < except_data.length; i++) {
				if (except_data[i] != "" && chat_id.indexOf(except_data[i]) != -1) {
					return false;
				}
			}
		}
		
		if(call_item.send_to != undefined && call_item.send_to == 2 && call[0].status == "accept" && call[0].chatId != chat_id){
		    await WAZIPER.auto_send(instance_id, chat_id, chat_id, "callresponder", call_item, false, false, false, function (result) { });
		    return false;
		}else if(call_item.send_to != undefined && call_item.send_to == 3 && call[0].status == "reject" && call[0].chatId != chat_id){
		    await WAZIPER.auto_send(instance_id, chat_id, chat_id, "callresponder", call_item, false, false, false, function (result) { });
		    return false;
		}else{
		    if(call_item.send_to != undefined && call_item.send_to == 1 && call[0].status == "reject" && call[0].chatId != chat_id || call_item.send_to != undefined && call_item.send_to == 1 && call[0].status == "accept" && call[0].chatId != chat_id){
		        await WAZIPER.auto_send(instance_id, chat_id, chat_id, "callresponder", call_item, false, false, false, function (result) { });
		        return false;
		    }
		    return false;
		}
	},

	chatbot: async function (instance_id, user_type, message) {
		var chat_id = message.key.remoteJid;

		counter = 0;
		var sent = false;
		var content = false;

		var body_message = {};

		if (message.message?.ephemeralMessage) {
			message.message = message.message.ephemeralMessage.message;
		}

		if (message.message?.buttonsResponseMessage != undefined) {
			content = message.message?.buttonsResponseMessage.selectedDisplayText;
			body_message['content'] = content;
			body_message['type'] = 'buttonsResponseMessage';
		} else if (message.message?.templateButtonReplyMessage != undefined) {
			content = message.message.templateButtonReplyMessage.selectedDisplayText;
			body_message['content'] = message.message.templateButtonReplyMessage.selectedDisplayText;
			body_message['type'] = 'templateButtonReplyMessage';
		} else if (message.message?.listResponseMessage != undefined) {
			content = message.message.listResponseMessage.title + " " + message.message.listResponseMessage.description;
			body_message['content'] = message.message.listResponseMessage.title + " " + message.message.listResponseMessage.description;
			body_message['type'] = 'listResponseMessage';
		} else if (typeof message.message?.extendedTextMessage != "undefined" && message.message.extendedTextMessage != null) {
			content = message.message.extendedTextMessage.text;
			body_message['content'] = message.message.extendedTextMessage.text;
			body_message['type'] = 'textMessage';
		} else if (typeof message.message?.imageMessage != "undefined" && message.message.imageMessage != null) {
			content = message.message.imageMessage.caption;
			body_message['content'] = message.message.imageMessage.caption;
			body_message['type'] = 'imageMessage';
			if (!content) {
				content = '📷';
				body_message['content'] = '📷';
			}
		}
		else if (typeof message.message?.stickerMessage != "undefined" && message.message.stickerMessage != null) {

			content = message.message?.stickerMessage?.caption;
			body_message['content'] = message.message?.stickerMessage?.caption;
			body_message['type'] = 'stickerMessage';
			if (!content) {
				content = '📷';
				body_message['content'] = '📷';
			}
		} else if (typeof message.message?.videoMessage != "undefined" && message.message.videoMessage != null) {
			content = message.message?.videoMessage?.caption;
			body_message['content'] = message.message?.videoMessage?.caption;
			body_message['type'] = 'videoMessage';
			if (!content) {
				content = '📹';
				body_message['content'] = '📹';
			}
		}
		else if (typeof message.message?.audioMessage != "undefined" && message.message.audioMessage != null) {
			content = message.message?.audioMessage?.caption;
			body_message['content'] = message.message?.audioMessage?.caption;
			body_message['type'] = 'audioMessage';
			if (!content) {
				content = '🎧';
				body_message['content'] = '🎧';
			}
		} else if (typeof message.message?.conversation != "undefined") {
			content = message.message.conversation;
			body_message['content'] = message.message.conversation;
			body_message['type'] = 'textMessage';
		}

		if (!content) {
			message['message'] = {};
			message['message']['conversation'] = '👋';
			content = '👋';

			body_message['content'] = '';
			body_message['type'] = 'emptyMessage';
		}
		body_message['messages'] = message.message;


		WAZIPER.webhook(instance_id, {
			event: "received_message", message: {
				'body_message': body_message,
				'message_key': message?.key,
				'push_name': message?.pushName ?? '',
				'from_contact': Common.get_phone(chat_id, null)
			}
		});

		if (body_message['type'] == 'emptyMessage') return false;

		var subscriptor_ = await Extend.getSubscriber(WAZIPER, message, instance_id);
		if (subscriptor_.enabled_chatbot == '0') {
			console.error('chatbot cant continue', instance_id, subscriptor_.chatid, subscriptor_.enabled_chatbot)
			return false;
		}

		var items = await Common.db_fetch("sp_whatsapp_chatbot", [{ instance_id: instance_id }, { status: 1 }, { run: 1 }]);
		if (!items) {
			return false;
		}

		var allow_continue = await Extend.updateSubscriber(WAZIPER, subscriptor_, content, instance_id, user_type, message, null);

		if (allow_continue) {

			items.forEach(async (item, index) => {

				var caption = item.caption;
				var keywords = item.keywords.split(",");

				var run = true;

				//Accept sent to all/group/user
				switch (item.send_to) {
					case 2:
						if (user_type == "group") run = false;;
						break;
					case 3:
						if (user_type == "user") run = false;
						break;
				}

				if (run) {
					var key_sent = false;
					if (item.type_search == 1) {
						for (var j = 0; j < keywords.length; j++) {
							if (content && !key_sent) {
								var msg = content.toLowerCase();
								if (msg.indexOf(keywords[j]) !== -1) {
									key_sent = true;
									sent = true;
									var ct = counter++;

									var allow_continue_cb = await Extend.updateSubscriber(WAZIPER, subscriptor_, content, instance_id, user_type, message, item);
									if (allow_continue_cb)
										setTimeout(function () {
											//WAZIPER.chatbot_latest_receive = moment().add(CHATBOT_RESET_TIME, 'm');
											WAZIPER.auto_send(instance_id, chat_id, chat_id, "chatbot", item, false, message, content, function (result) {
												if (item.nextBot != null && item.nextBot != '' && item.save_data !== 2) {
													Extend.nextBot(result, item, message, instance_id, user_type, WAZIPER);
												}
											});
										}, ct * chatbot_delay);
								}
							} else {
								break;
							}
						}
					} else {
						for (var j = 0; j < keywords.length; j++) {
							if (content && !key_sent) {
								var msg = content.toLowerCase();
								if (msg == keywords[j]) {
									key_sent = true;
									sent = true;
									var ct = counter++;

									var allow_continue_cb = await Extend.updateSubscriber(WAZIPER, subscriptor_, content, instance_id, user_type, message, item);
									if (allow_continue_cb)
										setTimeout(function () {
											//WAZIPER.chatbot_latest_receive = moment().add(CHATBOT_RESET_TIME, 'm');
											WAZIPER.auto_send(instance_id, chat_id, chat_id, "chatbot", item, false, message, content, function (result) {
												if (item.nextBot != null && item.nextBot != '' && item.save_data !== 2) {
													Extend.nextBot(result, item, message, instance_id, user_type, WAZIPER);
												}
											});
										}, ct * chatbot_delay);
								}
							} else {
								break;
							}
						}
					}
				}
			});


			if (!sent) {
				var item = await Common.db_get("sp_whatsapp_chatbot", [{ instance_id: instance_id }, { status: 1 }, { is_default: 1 }]);

				if (item) {
					var run = true;

					switch (item.send_to) {
						case 2:
							if (user_type == "group") run = false;;
							break;
						case 3:
							if (user_type == "user") run = false;
							break;
					}
					if (run) {
						WAZIPER.auto_send(instance_id, chat_id, chat_id, "chatbot", item, false, message, content, function (result) {
							Extend.nextBot(result, item, message, instance_id, user_type, WAZIPER);
						});
					}
				}
			}

		}

	},

	resetAi: async function (instance_id, res) {
		Extend.resetAi(instance_id);
		console.log(`${instance_id} OpenAi history restarted`);
		res.json({ status: 'success', message: `${instance_id} OpenAi history restarted`, data: { "instance_id": instance_id } });
	},

	send_cloud_template: async function (instance_id, access_token, req, res) {
		var chat_id = req.body.chat_id;
		var language_code = req.body.language_code;
		var template_name = req.body.template_name;
		var components = req.body.components;
		var team = await Common.db_get("sp_team", [{ ids: access_token }]);
		var type = "api"

		if (!team) {
			return res.json({ status: 'error', message: "The authentication process has failed" });
		}

		var account = await Common.db_get("sp_accounts", [{ token: instance_id }, { team_id: team.id }]);

		if (account && account.login_type == 1) {

			let item = {
				team_id: team.id
			}

			var limit = await WAZIPER.limit(item, type);
			if (!limit) {
				//return callback({ status: 0, stats: false, message: "The number of messages you have sent per month has exceeded the maximum limit" });
				return res.json({ status: 'error', message: "The number of messages you have sent per month has exceeded the maximum limit" });
			}

			const { access_token: bearer } = JSON.parse(account.tmp);
			const whatsappAPIURL = `https://graph.facebook.com/v19.0/${account.username}/messages`;

			let data = JSON.stringify({
				"messaging_product": "whatsapp",
				"recipient_type": "individual",
				"to": chat_id,
				"type": "template",
				"template": {
					"name": template_name,
					"language": {
						"code": language_code
					},
					"components": components
				}
			});

			let config = {
				method: 'post',
				maxBodyLength: Infinity,
				url: whatsappAPIURL,
				headers: {
					'Content-Type': 'application/json',
					'Authorization': `Bearer ${bearer}`
				},
				data: data
			};

			axios.request(config)
				.then(async (response) => {

					try {

						const message = response.data.messages[0];
						const pushname = response.data.contacts[0]?.profile?.name ?? instance_id;

						let message___ = await Extend.process_official_sent_message(JSON.parse(data), chat_id, message?.id ?? Common.makeid(), "", "template");

						//* LIVECHAT FUNCTION
						if ((config['extended_functions'] ?? true)) {
							Extend.chat.processChatMessages(WAZIPER, false, { messages: [message___] }, instance_id, true);
						}
						//* END LIVECHAT FUNCTION	
					} catch (error) {
						console.error(error)
					}


					console.log('Mensaje enviado: ', JSON.stringify(response.data, null, 4));
					WAZIPER.stats(instance_id, type, item, 1);
					return res.json({ status: 'success', message: "Success", "message": response.data });
				})
				.catch((error) => {
					console.error('Error al enviar mensaje: ', error);
					WAZIPER.stats(instance_id, type, item, 0);
					return res.json({ status: 'error', message: error });
				});
		}
	},

	send_message: async function (instance_id, access_token, req, res) {
		var type = req.query.type;
		var chat_id = req.body.chat_id;
		var media_url = req.body.media_url;
		var caption = req.body.caption ?? '';
		var filename = req.body.filename ?? '';
		var template = req.body.template ?? 0;
		var team = await Common.db_get("sp_team", [{ ids: access_token }]);

		if (!team) {
			return res.json({ status: 'error', message: "The authentication process has failed" });
		}
		
		if (chat_id.indexOf("g.us") !== -1) {
			chat_id = chat_id;
		} else {
		    chat_id = chat_id.split("@");
			chat_idd = await Common.check_especials(chat_id[0]);
			chat_id = chat_idd + "@" + chat_id[1];
		}

		item = {
			team_id: team.id,
			type: parseInt(type),
			template: type != 1 ? parseInt(template) : 0,
			caption: caption,
			media: media_url,
			filename: filename
		}

		await WAZIPER.auto_send(instance_id, chat_id, chat_id, "api", item, false, false, false, function (result) {
			console.log(result);
			if (result) {
				if (result.message != undefined) {
					result.message.status = "SUCCESS";
				}
				return res.json({ status: 'success', message: "Success", "message": result.message });
			} else {
				return res.json({ status: 'error', message: "Error" });
			}
		});
	},
	
	single_send_message: async function (instance_id, access_token, req, res) {
		var type = req.query.type;
		var chat_id = req.body.chat_id;
		var media_url = req.body.media_url;
		var caption = req.body.caption ?? '';
		var filename = req.body.filename ?? '';
		var template = req.body.template ?? 0;
		var team = await Common.db_get("sp_team", [{ ids: access_token }]);

		if (!team) {
			return res.json({ status: 'error', message: "The authentication process has failed" });
		}
		
		if (chat_id.indexOf("g.us") !== -1) {
			chat_id = chat_id;
		} else {
			chat_id = chat_id;
		}

		item = {
			team_id: team.id,
			type: parseInt(type),
			template: type != 1 ? parseInt(template) : 0,
			caption: caption,
			media: media_url,
			filename: filename
		}

		await WAZIPER.auto_send(instance_id, chat_id, chat_id, "direct", item, false, false, false, function (result) {
			console.log(result);
			if (result) {
				if (result.message != undefined) {
					result.message.status = "SUCCESS";
				}
				return res.json({ status: 'success', message: "Success", "message": result.message });
			} else {
				return res.json({ status: 'error', message: "Error" });
			}
		});
	},

	retry_onfail: async function (instance_id) {
		sessions[instance_id] = await WAZIPER.session(instance_id, true);
	},

	webhook_handler: async function (instance_id, req, res) {
		console.log('Mensaje recibido post', JSON.stringify(req.body));
		var account = await Common.db_get("sp_accounts", [{ token: instance_id }]);
		try {
			if (account && account.login_type == 1) {

				if (req.body.entry[0].changes[0].value.messages) {
					const message = req.body.entry[0].changes[0].value.messages[0];
					const pushname = req.body.entry[0].changes[0].value.contacts[0]?.profile?.name;

					if (message.from) {

						try {
							Extend.mark_as_read(message, instance_id);
						} catch (error) {

						}

						message_to_script = await Extend.process_official_message(message, pushname, false);

						//* LIVECHAT FUNCTION
						if ((config['extended_functions'] ?? true)) {
							Extend.chat.processChatMessages(WAZIPER, false, { messages: [message_to_script] }, instance_id, true);
						}
						//* END LIVECHAT FUNCTION

						await Common.sleep(1000);
						WAZIPER.chatbot(instance_id, "user", message_to_script);
						await Common.sleep(1000);
						WAZIPER.autoresponder(instance_id, "user", message_to_script);
					}
				}
			} else {
				res.status(400).send(`Instance ${instance_id} not exist`);
			}
		} catch (error) {

		} finally {
			res.status(200).send('OK');
		}

	},

  process_send_message: async function (chat_id, data, type, instance_id, phone_number, item, callback, type_media = '') {

    var account = await Common.db_get("sp_accounts", [{ token: instance_id }, { team_id: item.team_id }]);

    if (account && account.login_type == 1) {

      const { access_token: bearer } = JSON.parse(account.tmp);

      const whatsappAPIURL = `https://graph.facebook.com/v19.0/${account.username}/messages`;

      var messageBody = {};

      if (item.media != "" && item.media) {
        switch (type_media) {
          case "videoMessage":
            messageBody = {
              messaging_product: "whatsapp",
              to: chat_id,
              type: "video",
              video: {
                link: data.video.url,
                caption: data.caption
              },
              mimetype: data.mimetype
            }
            break;

          case "imageMessage":
            messageBody = {
              messaging_product: "whatsapp",
              to: chat_id,
              type: "image",
              image: {
                link: data.image.url,
                caption: data.caption
              }
            }
            break;

          case "audioMessage":

            messageBody = {
              messaging_product: "whatsapp",
              to: chat_id,
              type: "audio",
              audio: {
                link: data.audio.url
              },
              mimetype: data.mimetype
            }

            break;

          default:

            messageBody = {
              messaging_product: "whatsapp",
              to: chat_id,
              type: "document",
              document: {
                link: data.document.url,
                caption: data.caption,
                filename: data.fileName
              },
              mimetype: data.mimeType
            }

            break;
        }
      } else {

        switch (type_media) {
          case 'button':
            //console.log(JSON.stringify(data))
            messageBody = {
              messaging_product: "whatsapp",
              to: chat_id,
              type: "interactive",
              interactive: {
                type: "button",
                body: {
                  text: data.text ?? (data.caption ?? 'press button')
                },
                action: {
                  buttons: []
                }
              }
            }

            if (data.footer) {
              messageBody.interactive.footer = {
                text: data.footer
              }
            }

            if (data.image) {

              messageBody.interactive.header = {
                type: "image",
                image: {
                  link: data.image.url
                }
              }
            }

            data.templateButtons.forEach(element => {
              messageBody.interactive.action.buttons.push(
                {
                  type: "reply",
                  reply: {
                    id: element.quickReplyButton.id,
                    title: element.quickReplyButton.displayText
                  }
                }
              )
            });
            break;
          case 'list':
            //console.log(JSON.stringify(data))
            messageBody = {
              messaging_product: "whatsapp",
              recipient_type: "individual",
              to: chat_id,
              type: "interactive",
              interactive: {
                type: "list",
                header: {
                  type: "text",
                  text: data.title
                },
                body: {
                  text: data.text
                },
                footer: {
                  text: data.footer
                },
                action: {
                  button: data.buttonText,
                  sections: []
                }
              }
            }


            data.sections.forEach(section => {

              Common.special_log(section, 'section');

              let rows_to_add = [];
              section.rows.forEach(row => {

                Common.special_log(row, 'row');

                rows_to_add.push({
                  title: row.title,
                  id: row.rowId,
                  description: row.description ?? ''
                })
              });

              let section_to_add = {
                title: section.title,
                rows: rows_to_add
              }

              messageBody.interactive.action.sections.push(section_to_add);
            });
            break;

          case 'template':
            messageBody = data;
            break
          default:
            messageBody = {
              messaging_product: "whatsapp",
              to: chat_id,
              text: { body: data.text }
            }
            break;
        }

      }

      axios.post(whatsappAPIURL, messageBody, {
        headers: { Authorization: `Bearer ${bearer}` }
      }).then(async response => {

        try {
          const message = response.data.messages[0];
          let message___ = await Extend.process_official_sent_message(messageBody, chat_id, message?.id ?? Common.makeid());

          //* LIVECHAT FUNCTION
          if ((config['extended_functions'] ?? true)) {
            Extend.chat.processChatMessages(WAZIPER, false, { messages: [message___] }, instance_id, true);
          }
          //* END LIVECHAT FUNCTION	
        } catch (error) {
          console.error(error)
        }
        callback({ status: 1, type: type, phone_number: phone_number, stats: true, message: response.data });
        WAZIPER.stats(instance_id, type, item, 1);

      }).catch(error => {
        console.error('Error al enviar mensaje: ', error);
        callback({ status: 0, type: type, phone_number: phone_number, stats: true });
        WAZIPER.stats(instance_id, type, item, 0);
      })


    } else {
      var check_evo_acc = await Common.db_get("sp_accounts", [{ pid: account.pid }, { social_network: "whatsapp_evo" }]);
      var tp = ["button", "list"];
      if (check_evo_acc && tp.includes(type_media)) {
        console.log(check_evo_acc)
        var evo_sess = await Common.db_get("sp_whatsapp_sessions_evo", [{ instance_id: check_evo_acc.token }, { team_id: item.team_id }]);
        
        if (evo_sess && evo_sess.status == 1) {
          const tokens = JSON.parse(evo_sess.data);
          console.log(tokens.hash.jwt)
          var opt = {};
          if (type_media == "list") {
            opt = {
              number: chat_id,
              options: {
                delay: 1200,
                presence: "composing"
              },
              listMessage: {
                title: data.title,
                description: data.text,
                footerText: data.footer,
                buttonText: data.buttonText,
                sections: data.sections
              }
            }
          }
          
          console.log(opt)

          axios.post(config.evo_server + 'message/sendList/' + evo_sess.instance_id, opt, {
            headers: {
              'Content-Type': 'application/json',
              'Authorization': 'Bearer ' + tokens.hash.jwt
            }
          }).then(async(response) => {
              console.log(response.data)
            hist = {
              instance_id: instance_id,
              team_id: item.team_id,
              phone: chat_id.includes("g.us") == true ? chat_id : Common.get_phone(chat_id),
              type: type,
              message: "LIST MESSAGE TEMPLATE",
              status: 1,
              time_post: parseInt(Math.floor(new Date().getTime() / 1000)),
            };
            await Common.db_insert('sp_whatsapp_history', hist);
            callback({ status: 1, type: type, phone_number: phone_number, stats: true, message: response.data });
            WAZIPER.stats(instance_id, type, item, 1);
            
            
          }).catch(async(error) => {
              console.log(error)
            callback({ status: 0, type: type, phone_number: phone_number, stats: true });
            WAZIPER.stats(instance_id, type, item, 0);
            hist = {
              instance_id: instance_id,
              team_id: item.team_id,
              phone: chat_id.includes("g.us") == true ? chat_id : Common.get_phone(chat_id),
              type: type,
              message: "LIST MESSAGE TEMPLATE",
              status: 0,
              time_post: parseInt(Math.floor(new Date().getTime() / 1000)),
            };
            await Common.db_insert('sp_whatsapp_history', hist);
            
          })
        }
      } else {
        if (type_media != '' || type_media == "button" || type_media == "list" || type_media == "poll") {
          var cont = "TEMPLATE MESSAGE CONTENT"
        } else {
          cont = item.caption
        }
        if (type_media == "list") {
          datas = {
            forward: {
              key: { remoteJid: Common.get_phone(sessions[instance_id].user?.id, "wid"), fromMe: true },
              data,
            }
          }
        } else {
          datas = data
        }
        console.log(data)
        await sessions[instance_id].sendMessage(chat_id, data, { backgroundColor: '' }).then(async (message) => {
          console.log(message.message)
          callback({ status: 1, type: type, phone_number: phone_number, stats: true, message: message });
          WAZIPER.stats(instance_id, type, item, 1);

          var hist = {
            instance_id: instance_id,
            team_id: item.team_id,
            phone: chat_id.includes("g.us") == true ? chat_id : Common.get_phone(chat_id),
            type: type,
            message: cont,
            status: 1,
            time_post: parseInt(message.messageTimestamp),
          };
          var res = Common.db_insert('sp_whatsapp_history', hist);
        }).catch(async (err) => {
          console.log(err)
          var hist = {
            instance_id: instance_id,
            team_id: item.team_id,
            phone: chat_id.includes("g.us") == true ? chat_id : Common.get_phone(chat_id),
            type: type,
            message: cont,
            status: 0,
            time_post: parseInt(Math.floor(new Date().getTime() / 1000)),
          };
          var res = Common.db_insert('sp_whatsapp_history', hist);
          WAZIPER.retry_onfail(instance_id);
          callback({ status: 0, type: type, phone_number: phone_number, stats: true });
          WAZIPER.stats(instance_id, type, item, 0);
        });
      }
    }
  },

	auto_send: async function (instance_id, chat_id, phone_number, type, item, params, message, content, callback, retry = false) {

        var limit = await WAZIPER.limit(item, type);
        if (!limit) {
            return callback({ status: 0, stats: false, message: "The number of messages you have sent per month has exceeded the maximum limit" });
        }


        var { new_caption, can_continue } = await Extend.process_message(instance_id, item, chat_id, type, content, (err) => {
            sessions[instance_id].sendMessage(sessions[instance_id].user.id, { text: `The message could not be sent to ${chat_id} with AI due to the following error:\n${err}` })
                .then()
                .catch()
        });
        item.caption = new_caption;

        var params_org = params;

        if (type == 'bulk') {
            var account = await Common.db_get("sp_accounts", [{ token: instance_id }, { team_id: item.team_id }]);

            var isValid = await Extend.check_phone(sessions[instance_id], phone_number, params.is_valid, account.login_type == 1);

            if (!isValid) {
                callback({ status: 0, type: type, phone_number: phone_number, stats: true });
                WAZIPER.stats(instance_id, type, item, 0);
                can_continue = false;
            } else {
                params = params.params;
            }
        }


        if (can_continue) {
            try {
                await Extend.sendPresence(sessions[instance_id], chat_id, item);
            } catch (error) {

            }
            switch (item.type) {

                //Button 
                case 2:
                    var template = await WAZIPER.button_template_handler(item, params, message, instance_id);
                    if (template) {
                        WAZIPER.process_send_message(chat_id, template, type, instance_id, phone_number, item, callback, 'button');
                    }
                    break;
                //List Messages
                case 3:
                    var template = await WAZIPER.list_message_template_handler(item, params, message, instance_id);
                    if (template) {
                        WAZIPER.process_send_message(chat_id, template, type, instance_id, phone_number, item, callback, 'list');
                    }
                    break;
                case 4:
                    var template = await WAZIPER.poll_template_handler(item, params, message, instance_id);
                    if (template) {
                        WAZIPER.process_send_message(chat_id, template, type, instance_id, phone_number, item, callback, 'poll');
                        return false;
                    }
                    break;
                //Media & Text
                default:
                    var caption = await Extend.common_data(WAZIPER, sessions[instance_id], instance_id, item, message, spintax.unspin(item.caption));
                    caption = Common.params(params, caption);
                    if (item.media != "" && item.media) {
                        var mime = Common.ext2mime(item.media);
                        var post_type = Common.post_type(mime, 1);
                        var filename = (item.filename != undefined) ? item.filename : Common.get_file_name(item.media);

                        if (type == 'api' && item.filename && item.filename != '') {
                            mime = Common.ext2mime(item.filename);
                            post_type = Common.post_type(mime, 1);
                        }

                        switch (post_type) {
                            case "videoMessage":
                                var data = {
                                    video: { url: item.media },
                                    caption: caption
                                }

                                data['mimetype'] = mime;
                                break;

                            case "imageMessage":
                                var data = {
                                    image: { url: item.media },
                                    caption: caption
                                }
                                break;

                            case "audioMessage":
                                var data = {
                                    audio: { url: item.media },
                                    ptt: true,
                                    caption: caption
                                }
                                break;

                            default:
                                var data = {
                                    document: { url: item.media },
                                    fileName: filename,
                                    caption: caption,
                                    mimeType: mime
                                }
                                break;
                        }

                        console.log('send image message to ', chat_id);
                        WAZIPER.process_send_message(chat_id, data, type, instance_id, phone_number, item, callback, post_type);
                    } else {



                        console.log('send message to ', chat_id);
                        WAZIPER.process_send_message(chat_id, { text: caption }, type, instance_id, phone_number, item, callback);
                    }

            }
        }
    },
	limit: async function (item, type) {
		var time_now = Math.floor(new Date().getTime() / 1000);

		//
		var team = await Common.db_query(`SELECT owner FROM sp_team WHERE id = '` + item.team_id + `'`);
		if (!team) { return false }

		var user = await Common.db_query(`SELECT expiration_date FROM sp_users WHERE id = '` + team.owner + `'`);
		if (!user) { return false }

		if (user.expiration_date != 0 && user.expiration_date < time_now) {
			return false;
		}

		/*
		* Stats
		*/
		if (stats_history[item.team_id] == undefined) {
			stats_history[item.team_id] = {};
			var current_stats = await Common.db_get("sp_whatsapp_stats", [{ team_id: item.team_id }]);
			if (current_stats) {
				stats_history[item.team_id].wa_total_sent_by_month = current_stats.wa_total_sent_by_month;
				stats_history[item.team_id].wa_total_sent = current_stats.wa_total_sent;
				stats_history[item.team_id].wa_chatbot_count = current_stats.wa_chatbot_count;
				stats_history[item.team_id].wa_autoresponder_count = current_stats.wa_autoresponder_count;
				stats_history[item.team_id].wa_api_count = current_stats.wa_api_count;
				stats_history[item.team_id].wa_bulk_total_count = current_stats.wa_bulk_total_count;
				stats_history[item.team_id].wa_bulk_sent_count = current_stats.wa_bulk_sent_count;
				stats_history[item.team_id].wa_bulk_failed_count = current_stats.wa_bulk_failed_count;
				stats_history[item.team_id].wa_time_reset = current_stats.wa_time_reset;
				stats_history[item.team_id].next_update = current_stats.next_update;
			} else {
				return false;
			}
		}
		//End stats

		if (stats_history[item.team_id] != undefined) {
			if (stats_history[item.team_id].wa_time_reset < time_now) {
				stats_history[item.team_id].wa_total_sent_by_month = 0;
				stats_history[item.team_id].wa_time_reset = time_now + 30 * 60 * 60 * 24;
			}

			//if(stats_history[item.team_id].next_update < time_now){
			var current_stats = await Common.db_get("sp_whatsapp_stats", [{ team_id: item.team_id }]);
			if (current_stats) {
				stats_history[item.team_id].wa_time_reset = current_stats.wa_time_reset;
				if (current_stats.wa_time_reset == 0) {
					stats_history[item.team_id].wa_total_sent_by_month = 0;
					stats_history[item.team_id].wa_time_reset = time_now + 30 * 60 * 60 * 24;
				}
			}
			//}
		}

		/*
		* Limit by month
		*/
		if (limit_messages[item.team_id] == undefined) {
			limit_messages[item.team_id] = {};
			var team = await Common.db_get("sp_team", [{ id: item.team_id }]);
			if (team) {
				var permissioms = JSON.parse(team.permissions);
				limit_messages[item.team_id].whatsapp_message_per_month = parseInt(permissioms.whatsapp_message_per_month);
				limit_messages[item.team_id].next_update = 0;
			} else {
				return false;
			}
		}

		if (limit_messages[item.team_id].next_update < time_now) {
			var team = await Common.db_get("sp_team", [{ id: item.team_id }]);
			if (team) {
				var permissioms = JSON.parse(team.permissions);
				limit_messages[item.team_id].whatsapp_message_per_month = parseInt(permissioms.whatsapp_message_per_month);
				limit_messages[item.team_id].next_update = time_now + 30;
			}
		}
		//End limit by month

		/*
		* Stop all activity when over limit
		*/
		if (limit_messages[item.team_id] != undefined && stats_history[item.team_id] != undefined) {
			if (limit_messages[item.team_id].whatsapp_message_per_month <= stats_history[item.team_id].wa_total_sent_by_month) {

				//Stop bulk campaign
				switch (type) {
					case "bulk":
						await Common.db_update("sp_whatsapp_schedules", [{ run: 0, status: 0 }, { id: item.id }]);

						WAZIPER.io.emit('pause_campaign_' + item.team_id, {
							id: item.id,
							status: 0
						});

						break
				}

				return false;
			}
		}

		return true;
		//End stop all activity when over limit
	},

	stats: async function (instance_id, type, item, status) {
		var time_now = Math.floor(new Date().getTime() / 1000);

		if (stats_history[item.team_id].wa_time_reset < time_now) {
			stats_history[item.team_id].wa_total_sent_by_month = 0;
			stats_history[item.team_id].wa_time_reset = time_now + 30 * 60 * 60 * 24;
		}

		var sent = status ? 1 : 0;
		var failed = !status ? 1 : 0;

		stats_history[item.team_id].wa_total_sent_by_month += sent;
		stats_history[item.team_id].wa_total_sent += sent;

		switch (type) {
			case "chatbot":
				if (chatbots[item.id] == undefined) {
					chatbots[item.id] = {};
				}

				if (
					chatbots[item.id].chatbot_sent == undefined &&
					chatbots[item.id].chatbot_failed == undefined
				) {
					chatbots[item.id].chatbot_sent = item.sent;
					chatbots[item.id].chatbot_failed = item.failed;
				}

				chatbots[item.id].chatbot_sent += (status ? 1 : 0);
				chatbots[item.id].chatbot_failed += (!status ? 1 : 0);

				stats_history[item.team_id].wa_chatbot_count += sent;

				var total_sent = chatbots[item.id].chatbot_sent;
				var total_failed = chatbots[item.id].chatbot_failed;
				var data = {
					sent: total_sent,
					failed: total_failed,
				};

				await Common.db_update("sp_whatsapp_chatbot", [data, { id: item.id }]);
				break;

			case "autoresponder":
				if (!sessions[instance_id]) {
					sessions[instance_id] = {}
				}

				if (
					sessions[instance_id].autoresponder_sent == undefined &&
					sessions[instance_id].autoresponder_failed == undefined
				) {
					sessions[instance_id].autoresponder_sent = item.sent;
					sessions[instance_id].autoresponder_failed = item.sent;
				}

				sessions[instance_id].autoresponder_sent += (status ? 1 : 0);
				sessions[instance_id].autoresponder_failed += (!status ? 1 : 0);

				stats_history[item.team_id].wa_autoresponder_count += sent;

				var total_sent = sessions[instance_id].autoresponder_sent;
				var total_failed = sessions[instance_id].autoresponder_failed;
				var data = {
					sent: total_sent,
					failed: total_failed,
				};

				await Common.db_update("sp_whatsapp_autoresponder", [data, { id: item.id }]);
				break;

			case "bulk":
				stats_history[item.team_id].wa_bulk_total_count += 1;
				stats_history[item.team_id].wa_bulk_sent_count += sent;
				stats_history[item.team_id].wa_bulk_failed_count += failed;
				break;

			case "api":
				stats_history[item.team_id].wa_api_count += sent;
				break;
		}

		/*
		* Update stats
		*/
		if (stats_history[item.team_id].next_update < time_now) {
			stats_history[item.team_id].next_update = time_now + 30;
		}
		await Common.db_update("sp_whatsapp_stats", [stats_history[item.team_id], { team_id: item.team_id }]);
		//End update stats

	},

createInteractiveButtonsFromButton: (buttons) => {
    const buttonsArray = [];
    buttons?.map((button) => {
        if (button.name === 'quick_reply') {
            buttonsArray.push({
                name: 'quick_reply',
                buttonParamsJson: JSON.stringify({
                    display_text: button.display_text,
                    id: button.id,
                    disabled: false
                })
            });
        } else if (button.name === 'cta_url') {
            // Verifica se a URL contém o padrão de código OTP
            if (button.url.includes('https://www.whatsapp.com/otp/code/?otp_type=COPY_CODE&code=()')) {
                const code = new URLSearchParams(button.url.split('?')[1]).get('code'); // Obtém o código OTP da URL
                buttonsArray.push({
                    name: 'cta_copy',
                    buttonParamsJson: JSON.stringify({
                        display_text: 'Copiar Código',
                        id: button.id || 'unique_id',
                        copy_code: code,
                        disabled: false
                    })
                });
            } else {
                buttonsArray.push({
                    name: 'cta_url',
                    buttonParamsJson: JSON.stringify({
                        display_text: button.display_text,
                        id: button.id,
                        url: button.url,
                        disabled: false
                    })
                });
            }
        } else if (button.name === 'cta_call') {
            buttonsArray.push({
                name: 'cta_call',
                buttonParamsJson: JSON.stringify({
                    display_text: button.display_text,
                    id: button.id,
                    phone_number: button.phone_number,
                    disabled: false
                })
            });
        }
    });
    return buttonsArray;
},


// Main function
button_template_handler: async function (item, params, message, instance_id) {
    var template_id = item.template;
    var template = await Common.db_get("sp_whatsapp_template", [{ id: template_id }, { type: 2 }]);
    console.log('button_template_handler template', JSON.stringify(template))
    
    if (template) {
        var data = JSON.parse(template.data);

        var interactiveMessage = {
            header: {
                title: data.title || "Botão",  // Atribuindo dinamicamente data.title, ou um valor padrão
                hasMediaAttachment: false
            },
            body: {
                text: ""
            },
            footer: {},
            nativeFlowMessage: {
                buttons: []
            }
        };
        
        // Se precisar processar data.title (similar ao caption):
        if (data.title !== undefined) {
            data.title = spintax.unspin(data.title);
            data.title = await Extend.common_data(WAZIPER, sessions[instance_id], instance_id, item, message, data.title);
            data.title = Common.params(params, data.title);
            interactiveMessage.header.title = data.title;  // Atualiza o header.title dinamicamente
        } else {
            interactiveMessage.header.title = "Botão";  // Valor padrão caso data.title não esteja definido
        }

        // Process text content
        if (data.text !== undefined) {
            data.text = spintax.unspin(data.text);
            data.text = await Extend.common_data(WAZIPER, sessions[instance_id], instance_id, item, message, data.text);
            data.text = Common.params(params, data.text);
            interactiveMessage.body.text = data.text;
        }

        // Process footer
        if (data.footer !== undefined) {
            data.footer = spintax.unspin(data.footer);
            data.footer = await Extend.common_data(WAZIPER, sessions[instance_id], instance_id, item, message, data.footer);
            data.footer = Common.params(params, data.footer);
            interactiveMessage.footer.text = data.footer;
        }

        // Process caption and media
        if (data.caption !== undefined) {
            data.caption = spintax.unspin(data.caption);
            data.caption = await Extend.common_data(WAZIPER, sessions[instance_id], instance_id, item, message, data.caption);
            data.caption = Common.params(params, data.caption);
            interactiveMessage.body.text = data.caption;
        }

        // If there's media, you need to add it to the header
        if (data.image) {
            interactiveMessage.header.hasMediaAttachment = true;
            interactiveMessage.header.imageMessage = data.image;
        } else if (data.video) {
            interactiveMessage.header.hasMediaAttachment = true;
            interactiveMessage.header.videoMessage = data.video;
        } else if (data.document) {
            interactiveMessage.header.hasMediaAttachment = true;
            interactiveMessage.header.documentMessage = data.document;
        } else {
            interactiveMessage.header.hasMediaAttachment = false;
        }

        // Process buttons
        if (data.templateButtons && data.templateButtons.length > 0) {
            for (var i = 0; i < data.templateButtons.length; i++) {
                var buttonData = data.templateButtons[i];
                var button = null;

                if (buttonData.quickReplyButton !== undefined) {
                    var displayText = spintax.unspin(buttonData.quickReplyButton.displayText);
                    displayText = await Extend.common_data(WAZIPER, sessions[instance_id], instance_id, item, message, displayText);
                    displayText = Common.params(params, displayText);
                    button = {
                        name: 'quick_reply',
                        buttonParamsJson: JSON.stringify({
                            display_text: displayText,
                            id: buttonData.quickReplyButton.id || buttonData.quickReplyButton.displayText,
                            disabled: false
                        })
                    };
                }

                if (buttonData.urlButton !== undefined) {
                    var displayText = spintax.unspin(buttonData.urlButton.displayText);
                    displayText = await Extend.common_data(WAZIPER, sessions[instance_id], instance_id, item, message, displayText);
                    displayText = Common.params(params, displayText);

                    // Verifica se a URL contém o padrão de código OTP
                    if (buttonData.urlButton.url.includes('https://www.whatsapp.com/otp/code/?otp_type=COPY_CODE&code=()')) {
                        const code = new URLSearchParams(buttonData.urlButton.url.split('?')[1]).get('code'); // Obtém o código OTP da URL
                        button = {
                            name: 'cta_copy',
                            buttonParamsJson: JSON.stringify({
                                display_text: 'Copiar Código',
                                id: buttonData.urlButton.id || buttonData.urlButton.displayText,
                                copy_code: code,
                                disabled: false
                            })
                        };
                    } else {
                        button = {
                            name: 'cta_url',
                            buttonParamsJson: JSON.stringify({
                                display_text: displayText,
                                id: buttonData.urlButton.id || buttonData.urlButton.displayText,
                                url: buttonData.urlButton.url,
                                disabled: false
                            })
                        };
                    }
                }

                if (buttonData.callButton !== undefined) {
                    var displayText = spintax.unspin(buttonData.callButton.displayText);
                    displayText = await Extend.common_data(WAZIPER, sessions[instance_id], instance_id, item, message, displayText);
                    displayText = Common.params(params, displayText);
                
                    button = {
                        name: 'cta_call',
                        buttonParamsJson: JSON.stringify({
                            display_text: displayText,
                            id: buttonData.callButton.id || buttonData.callButton.displayText,
                            phone_number: buttonData.callButton.phoneNumber, // Certifique-se de que o número de telefone está sendo incluído
                            disabled: false
                        })
                    };
                }

                if (button) {
                    interactiveMessage.nativeFlowMessage.buttons.push(button);
                }
            }
        }

        // Return the complete interactive message
        return  { interactiveMessage: interactiveMessage };
    }

    return false;
},
	list_message_template_handler: async function (item, params, message, instance_id) {
		var template_id = item.template;
		var template = await Common.db_get("sp_whatsapp_template", [{ id: template_id }, { type: 1 }]);
		if (template) {

			var data = JSON.parse(template.data);

			//console.log(WAZIPER.sessions);
			if (data.text != undefined) {
				data.text = spintax.unspin(data.text);
				data.text = await Extend.common_data(
					WAZIPER
					, WAZIPER.sessions[instance_id]
					, instance_id
					, item, message
					, data.text
				);
				data.text = Common.params(params, data.text);
				//delete data.text;
			}

			if (data.footer != undefined) {
				data.footer = spintax.unspin(data.footer);
				data.footer = await Extend.common_data(WAZIPER, WAZIPER.sessions[instance_id], instance_id, item, message, data.footer);
				data.footer = Common.params(params, data.footer);
				//delete data.footer;
			}

			if (data.title != undefined) {
				data.title = spintax.unspin(data.title);
				data.title = await Extend.common_data(WAZIPER, WAZIPER.sessions[instance_id], instance_id, item, message, data.title);
				data.title = Common.params(params, data.title);
			}

			if (data.buttonText != undefined) {
				data.buttonText = spintax.unspin(data.buttonText);
				data.buttonText = await Extend.common_data(WAZIPER, WAZIPER.sessions[instance_id], instance_id, item, message, data.buttonText);
				data.buttonText = Common.params(params, data.buttonText);
			}

			for (var i = 0; i < data.sections.length; i++) {
				var sessions = data.sections;
				if (data.sections[i]) {
					if (data.sections[i].title != undefined) {
						data.sections[i].title = spintax.unspin(data.sections[i].title);
						data.sections[i].title = await Extend.common_data(WAZIPER, WAZIPER.sessions[instance_id], instance_id, item, message, data.sections[i].title);
						data.sections[i].title = Common.params(params, data.sections[i].title);
					}

					for (var j = 0; j < data.sections[i].rows.length; j++) {
						if (data.sections[i].rows[j].title != undefined) {
							data.sections[i].rows[j].title = spintax.unspin(data.sections[i].rows[j].title);
							data.sections[i].rows[j].title = await Extend.common_data(WAZIPER, WAZIPER.sessions[instance_id], instance_id, item, message, data.sections[i].rows[j].title);
							data.sections[i].rows[j].title = Common.params(params, data.sections[i].rows[j].title);
						}

						if (data.sections[i].rows[j].description != undefined) {
							data.sections[i].rows[j].description = spintax.unspin(data.sections[i].rows[j].description);
							data.sections[i].rows[j].description = await Extend.common_data(WAZIPER, WAZIPER.sessions[instance_id], instance_id, item, message, data.sections[i].rows[j].description);
							data.sections[i].rows[j].description = Common.params(params, data.sections[i].rows[j].description);
						}
						data.sections[i].rows[j].rowId = data.sections[i].rows[j].rowId;
						console.log(data.sections[i].rows[j])
					}
				}
			}
			
			data.listType = 2;
			var lm = {
			    title: data.title,
			    text: data.text,
			    buttonText: data.buttonText,
			    footer: data.footer,
			    sections: data.sections,
			    listType: 2
			};
			var msg = {
			    listMessage: lm
			}
			console.log(msg);
			return data;
		}

		return false;
	},
	
	poll_template_handler: async function (item, params, message, instance_id) {
	    var template_id = item.template;
		var template = await Common.db_get("sp_whatsapp_template", [{ id: template_id }, { type: 3 }]);
		if(template){
		    var data = JSON.parse(template.data);
		    if(data.name != undefined){
		        data.name = spintax.unspin(data.name);
		        data.name = await Extend.common_data(WAZIPER, sessions[instance_id], instance_id, item, message, data.name);
		        data.name = Common.params(params, data.name);
		    }
		    
		    for(i = 0; i < data.values.length; i++){
		        data.values[i] = spintax.unspin(data.values[i]);
		        data.values[i] = await Extend.common_data(WAZIPER, sessions[instance_id], instance_id, item, message, data.values[i]);
		        data.values[i] = Common.params(params, data.values[i]);
		    }
		    
		    var pollOpt = {
		        name: data.name,
		        values: data.values,
		        selectableCount: data.selectableCount == 0 ? null : 1
		    }
		    
		    pollOpt = { poll: pollOpt };
		    
		    return pollOpt;
		}
	},

	live_back: async function () {
		var account = await Common.db_query(`
			SELECT a.changed, a.token as instance_id, a.id, b.ids as access_token 
			FROM sp_accounts as a 
			INNER JOIN sp_team as b ON a.team_id=b.id 
			WHERE a.social_network = 'whatsapp' AND a.login_type = '2' AND a.status = 1 
			ORDER BY a.changed ASC 
			LIMIT 1
		`);

		if (account) {

			let wsstatus = sessions[account.instance_id]?.ws?.readyState || sessions[account.instance_id]?.ws?.socket?._readyState;

			if (wsstatus == 3) {
				console.error('checking', account.instance_id, 'ws status:', wsstatus, 'restarting');
			} else {
				console.log('checking', account.instance_id, 'ws status:', wsstatus, 'keep');
			}

			var now = new Date().getTime() / 1000;
			await Common.db_update("sp_accounts", [{ changed: now }, { id: account.id }]);
			await WAZIPER.instance(account.access_token, account.instance_id, false, async (client) => {


				if (client.user && client.user.name) {
					await Common.db_update("sp_accounts", [{ name: client.user.name }, { id: account.id }]);
				}

				if (client.qrcode != undefined && client.qrcode != "") {
					await WAZIPER.logout(account.instance_id);
				}
			}, wsstatus == 3);
		}

		//Close new session after 2 minutes
		if (Object.keys(new_sessions).length) {
			Object.keys(new_sessions).forEach(async (instance_id) => {
				var now = new Date().getTime() / 1000;
				if (now > new_sessions[instance_id] && sessions[instance_id] && sessions[instance_id].qrcode != undefined) {
					delete new_sessions[instance_id];
					await WAZIPER.logout(instance_id);
				}
			});
		}

		console.log("Total sessions: ", Object.keys(sessions).length);
		console.log("Total queue sessions: ", Object.keys(new_sessions).length);
	},

	add_account: async function (instance_id, team_id, wa_info, account) {
		if (!account) {
			await Common.db_insert_account(instance_id, team_id, wa_info);
		} else {
			var old_instance_id = account.token;

			await Common.db_update_account(instance_id, team_id, wa_info, account.id);

			//Update old session
			if (instance_id != old_instance_id) {
				await Common.db_delete("sp_whatsapp_sessions", [{ instance_id: old_instance_id }]);
				await Common.db_update("sp_whatsapp_autoresponder", [{ instance_id: instance_id }, { instance_id: old_instance_id }]);
				await Common.db_update("sp_whatsapp_chatbot", [{ instance_id: instance_id }, { instance_id: old_instance_id }]);
				await Common.db_update("sp_whatsapp_webhook", [{ instance_id: instance_id }, { instance_id: old_instance_id }]);
				WAZIPER.logout(old_instance_id);
			}

			var pid = Common.get_phone(wa_info.id, 'wid');
			var account_other = await Common.db_query(`SELECT id FROM sp_accounts WHERE pid = '` + pid + `' AND team_id = '` + team_id + `' AND id != '` + account.id + `'`);
			if (account_other) {
				await Common.db_delete("sp_accounts", [{ id: account_other.id }]);
			}
		}

		/*Create WhatsApp stats for user*/
		var wa_stats = await Common.db_get("sp_whatsapp_stats", [{ team_id: team_id }]);
		if (!wa_stats) await Common.db_insert_stats(team_id);
	}
}



module.exports = WAZIPER;

cron.schedule('*/1 * * * * *', function () {
	WAZIPER.live_back();
});

cron.schedule('*/5 * * * * *', function () {
	//console.log('bulk init cron')
	WAZIPER.bulk_messaging();
});

cron.schedule('*/5 * * * * *', function () {
	Extend.validatePhones(WAZIPER, sessions);
});