const config = require("./config.js");
const Common = require("./waziper/common.js");
const WAZIPER = require("./waziper/waziper.js");
const express = require('express');
const path = require('path')

//WAZIPER.app.use('/files', express.static('files'))
WAZIPER.app.use('/files', express.static(path.join(__dirname, 'files')));

WAZIPER.app.get('/instance', WAZIPER.cors, async (req, res) => {
    var access_token = req.query.access_token;
    var instance_id = req.query.instance_id;

    await WAZIPER.instance(access_token, instance_id,  res, async (client) => {
        await WAZIPER.get_info(instance_id, res);
    });
});

WAZIPER.app.get('/get_qrcode', WAZIPER.cors, async (req, res) => {
    var access_token = req.query.access_token;
    var instance_id = req.query.instance_id;

    await WAZIPER.instance(access_token, instance_id,  res, async (client) => {
        await WAZIPER.get_qrcode(instance_id, res);
    });
});

WAZIPER.app.get('/get_paircode', WAZIPER.cors, async (req, res) => {
    var access_token = req.query.access_token;
    var instance_id = req.query.instance_id;

    await WAZIPER.instance(access_token, instance_id, res, async (client) => {
        await WAZIPER.get_pairing(instance_id, req, res);
    });
});

WAZIPER.app.get('/get_groups', WAZIPER.cors, async (req, res) => {
    var access_token = req.query.access_token;
    var instance_id = req.query.instance_id;

    await WAZIPER.instance(access_token, instance_id,  res, async (client) => {
        await WAZIPER.get_groups(instance_id, res);
    });
});

WAZIPER.app.get('/logout', WAZIPER.cors, async (req, res) => {
    var access_token = req.query.access_token;
    var instance_id = req.query.instance_id;
    WAZIPER.logout(instance_id, res);
});

WAZIPER.app.post('/send_message', WAZIPER.cors, async (req, res) => {
    var access_token = req.query.access_token;
    var instance_id = req.query.instance_id;

    await WAZIPER.instance(access_token, instance_id, res, async (client) => {
        WAZIPER.send_message(instance_id, access_token, req, res);
    });
});

WAZIPER.app.post('/direct_send_message', WAZIPER.cors, async (req, res) => {
    var access_token = req.query.access_token;
    var instance_id = req.query.instance_id;

    await WAZIPER.instance(access_token, instance_id, res, async (client) => {
        WAZIPER.single_send_message(instance_id, access_token, req, res);
    });
});


WAZIPER.app.post('/send_template', WAZIPER.cors, async (req, res) => {
    var access_token = req.query.access_token;
    var instance_id = req.query.instance_id;

    await WAZIPER.instance(access_token, instance_id,  res, async (client) => {
        WAZIPER.send_cloud_template(instance_id, access_token, req, res);
    });
});

WAZIPER.app.get('/reset', WAZIPER.cors, async function (req, res, next) {
    var api_key = await Common.db_query(`select value from sp_options where name = 'admin_api_key'`, true);
    if (api_key) {
        if (req.query.api_key == api_key.value) {
            res.json({
                status: 'success',
                message: 'Success'
            });

            process.exit();
        } else {
            res.json({
                status: 'error',
                message: 'not allowed',
                api: api_key
            });
        }
    }

});


WAZIPER.app.get('/clear_cache_ai', WAZIPER.cors, async function (req, res, next) {

    var access_token = req.query.access_token;
    var instance_id = req.query.instance_id;
    WAZIPER.resetAi(instance_id, res);
});

WAZIPER.app.post('/webhook/:accountId', async function (req, res) {
    WAZIPER.webhook_handler(req.params.accountId, req, res);
})

WAZIPER.app.get('/webhook/:accountId', async function (req, res) {
    const message = req.body;

    let VERIFY_TOKEN = await Common.db_get('sp_options', [{ name: 'wa_verify_token' }]);
    VERIFY_TOKEN = VERIFY_TOKEN.value;
    const accountId = req.params.accountId; // Obtienes accountId de la URL.

    // ParÃ¡metros de la solicitud de verificaciÃ³n de Facebook
    let mode = req.query['hub.mode'];
    let token = req.query['hub.verify_token'];
    let challenge = req.query['hub.challenge'];

    // Verifica si el token y el modo son correctos
    if (mode === 'subscribe' && token === VERIFY_TOKEN) {
        console.log(`Verified webhook for account: ${accountId}`);
        res.send(challenge); // Responde el 'challenge' que Facebook enviÃ³
    } else {
        res.sendStatus(403); // EnvÃ­a un cÃ³digo de estado de prohibiciÃ³n si los tokens no coinciden
    }
})


WAZIPER.app.get('/', WAZIPER.cors, async (req, res) => {
    return res.json({ status: 'success', message: `WELCOME TO XPERT DEVELOPMENT!!!` });
});

WAZIPER.server.listen(config.port, async () => {
    console.log(`HELLO Welcome to ORIZEN SOFTWARES PVT LTD🟢`);
});