<section class="sp-banner p-t-90 position-relative">
    <div class="position-absolute zindex-1 t-0 l-0 w-100">
        <svg class="scene" width="1440" height="800" preserveAspectRatio="xMinYMid slice" viewBox="0 0 1440 800" xmlns:pathdata="http://www.codrops.com/">
            <defs>
                <linearGradient id="gradient-1" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop stop-color="#f19872"/>
                    <stop offset="1" stop-color="#e86c9a"/>
                </linearGradient>
                <linearGradient id="gradient-2" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop stop-color="#0947db"/>
                    <stop offset="1" stop-color="#07d89d"/>
                </linearGradient>
                <linearGradient id="gradient-3" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop stop-color="#ee2d29"/>
                    <stop offset="1" stop-color="#f8ae2c"/>
                </linearGradient>
                <linearGradient id="gradient-4" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop stop-color="#3a3d98"/>
                    <stop offset="1" stop-color="#6f22b9"/>
                </linearGradient>
                <linearGradient id="gradient-5" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop stop-color="#9d316e"/>
                    <stop offset="1" stop-color="#de2d3e"/>
                </linearGradient>
                <linearGradient id="gradient-6" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop stop-color="#00ac53"/>
                    <stop offset="1" stop-color="#23c3e0"/>
                </linearGradient>
            </defs>
            <g class="blob-1">
                <path d="M 382.9,69.64 C 375.1,14.22 296.4,-55.5 243.8,-46.79 191.2,-38.08 156.2,-36.94 118.6,-50.49 80.98,-64.04 52.11,-60.24 17.7,-25.44 -16.71,9.355 -52.82,94.93 -55.27,139.3 -57.72,183.7 -49.76,192.9 -19.05,201.3 11.66,209.7 54.92,201.4 92.87,229.8 130.8,258.2 166.4,326.2 204.1,345.9 241.8,365.6 259.2,351.7 284.3,318.5 309.4,285.3 344.5,223.8 362.8,182.2 381.1,140.6 390.7,125.1 382.9,69.64 Z" pathdata:id="M 5153,15.13 C 5039,-791.7 3862,-1807 3080,-1680 2294,-1552 1772,-1536 1211,-1733 649,-1930 218.2,-1875 -295.2,-1369 -807.6,-862 -1347,382.9 -1383,1028 -1420,1675 -1302,1809 -843.9,1931 -385.4,2053 260.6,1933 826.6,2345 1391,2758 1924,3749 2487,4035 3049,4321 3308,4119 3682,3635 4058,3153 4581,2258 4854,1653 5127,1047 5271,821 5153,15.13 Z"/>
                <path d="M 334.7,65.61 C 325.3,7.593 270.9,-34.46 218.5,-24.5 172.3,-15.71 125.4,-34.55 78.72,-32.93 47.06,-31.83 19.45,-9.456 0.2296,18.39 -25.16,55.18 -48.95,99.72 -44.87,147.7 -42.59,174.6 -14.84,187.6 8.083,186.8 43.43,185.5 81.49,185.3 113.3,207.7 149.3,233 174.3,278.3 216.4,291.8 245.2,301 273.1,277.4 290.9,252.8 328.2,201.4 345.4,131.6 334.7,65.61 Z" pathdata:id="M 4434,-44.03 C 4293,-887.2 3482,-1499 2701,-1354 2012,-1227 1312,-1500 615.5,-1477 142.6,-1462 -269,-1137 -555.8,-730.8 -935.1,-195.7 -1289,452.3 -1230,1150 -1194,1541 -780,1732 -438.8,1719 88.59,1702 657.1,1697 1131,2023 1670,2392 2042,3051 2671,3246 3100,3381 3516,3037 3782,2680 4338,1933 4594,916 4434,-44.03 Z"/>
                <path d="M 301.9,109.3 C 293.3,47.28 237.7,6.176 183,4.292 145.9,3.015 112.1,-30.68 74.57,-21.98 34.9,-12.78 7.294,25.18 -14.63,60.94 -31.83,88.99 -48.3,127.3 -33.65,159.7 -23.55,182 5.521,181.2 25.57,177 78.49,166 132.1,191.4 170.7,232.8 188.4,251.7 212.7,272.9 238.5,266.6 270.8,258.7 289.6,222 298.2,188.1 304.7,162.7 305.6,135.5 301.9,109.3 Z" pathdata:id="M 3945,591.6 C 3818,-310.8 2988,-908.9 2170,-935.4 1618,-953.9 1113,-1444 553.6,-1318 -38.52,-1184 -450.6,-632.1 -777.1,-111.6 -1035,296.3 -1280,853.2 -1061,1324 -911.5,1651 -477,1639 -177.4,1578 612.1,1417 1412,1787 1988,2391 2252,2663 2615,2972 2999,2879 3481,2766 3761,2232 3891,1739 3987,1369 4001,973.5 3945,591.6 Z"/>
                <path d="M 270.4,134.6 C 261.3,81.3 218.6,43.99 174.5,26.82 143.8,14.87 112.1,-6.204 79.55,4.503 28.51,21.31 -15.53,68.11 -29.07,126.5 -32.74,142.3 -24.82,163.4 -8.561,165.9 28.45,171.7 65.61,154.5 102.4,169 144.1,185.5 173.6,227.9 216.1,241.9 241.4,250.2 263.3,218.9 267.7,191.8 270.8,173 273.7,153.5 270.4,134.6 Z" pathdata:id="M 3476,960.3 C 3339,184.5 2702,-358.8 2044,-608.5 1587,-781.2 1113,-1088 627.8,-933.3 -133.9,-687.9 -790.9,-7.384 -993,842.2 -1048,1072 -929.2,1380 -686.7,1416 -134.6,1501 419.9,1250 968.6,1462 1591,1702 2030,2318 2666,2521 3043,2642 3369,2188 3434,1793 3481,1520 3526,1235 3476,960.3 Z"/>
                <path d="M 229.8,128.8 C 219.9,79.76 177.5,48.4 135.7,37.08 107.6,29.47 77.51,16.26 50.19,30.71 15.21,49.21 -17.25,84.68 -19.56,130.1 -20.49,148.3 -1.181,158.1 12.81,156.9 54.23,153.4 97.99,150.9 137.1,171.2 160,183.1 183.3,204.3 209.2,198.6 228.3,194.4 233.1,167.4 231.8,148.1 231.3,141.6 231.1,135.1 229.8,128.8 Z" pathdata:id="M 2870,875.1 C 2721,162 2089,-294.5 1466,-458.8 1047,-569.7 597.1,-761.2 189.4,-551.2 -332.2,-282.3 -816.4,233.3 -850.7,895.2 -864.5,1158 -576.8,1301 -368.5,1285 249.9,1234 902.6,1198 1487,1493 1829,1667 2176,1974 2562,1892 2847,1829 2920,1439 2901,1157 2891,1062 2890,967.4 2870,875.1 Z"/>
                <path d="M 200.5,139 C 193.3,94.06 156.4,62.79 118.8,51.33 93.26,43.54 64.65,33.02 39.95,47.98 14.83,63.19 -8.802,89.75 -10.59,123.7 -11.24,136 -3.241,146.5 7.448,149.2 27.58,154.4 47.84,148.7 68.23,150 102,152.2 134.8,162.2 166.7,174.9 178.5,179.6 194.3,175.5 199.1,161 201.4,154.1 201.7,146.3 200.5,139 Z" pathdata:id="M 2432,1023 C 2325,370.1 1775,-85.13 1214,-251.5 831.7,-365.3 405.3,-518.1 36.61,-300.3 -338.1,-78.65 -690.2,307.2 -716.7,801.3 -727.3,979.5 -607.2,1133 -448,1172 -147.8,1248 154.5,1165 458.7,1184 962.8,1216 1453,1361 1928,1547 2103,1616 2340,1555 2412,1343 2446,1244 2450,1130 2432,1023 Z"/>
                <path d="M 181,126.6 C 174.1,88.88 143,63.51 111.8,52.84 96.72,47.68 81.29,42.27 65.2,44.56 48.48,46.94 34.04,57.55 22.98,71.55 12.53,84.78 0.8786,106.1 11.19,122.3 23.14,141.1 47.82,136.4 66.4,136.9 100.4,137.9 132.8,153.9 166.7,152.9 177.4,152.6 183.1,137.9 181,126.6 Z" pathdata:id="M 2142,843.1 C 2040,294.9 1574,-74.14 1108,-229.7 884.1,-305 654.1,-383.9 413.9,-350.6 164.3,-315.8 -51.66,-161 -216.3,42.61 -372.4,235.2 -546.1,545.3 -392,780.8 -214.3,1055 154.5,985.6 431.8,993.8 938.2,1008 1422,1241 1928,1225 2088,1221 2172,1008 2142,843.1 Z"/>
            </g>
        </svg>
    </div>
    <div class="container py-5 position-relative zindex-2">
        <div class="row justify-content-center align-items-center">
            <div class="col-lg-6 col-md-12 mb-6">
                <div class="position-relative" data-aos="fade-down">
                    <div class="font-two fw-9 fs-50 text-primary mb-4 trns-text bg-primary text-uppercase lh-65">
                        <?php _e("Messaging So Smooth, You'll Forget You’re Typing!", 0)?>
                    </div>
                </div>
                <div class="mb-6 mw-550 fs-18 text-gray-700" data-aos="fade-up">
                    <?php _e("We help you schedule posts like a boss, analyze like a genius, and optimize like you’ve got a degree in viral content!")?>
                </div>

                <div class="d-flex" data-aos="fade-left">
                    <a class="btn btn-primary me-3 click-menu" data-id="features" href="#features"><?php _e("Learn more")?></a>
                    <div class="position-relative">
                        <div class="position-absolute d-flex mn-25 l-90 text-nowrap fst-italic">
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/push_arrow_down.png" class="position-relative">
                            <div class="text-primary font-four mn-5 p-l-10"><?php _e("No credit card required")?></div>
                        </div>
                        <a class="btn btn-dark" href="<?php _ec( base_url("login") )?>"><?php _e("Get start now")?></a>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-12 mb-6">
                <div class="sp-banner-img mw-550 position-relative p-l-30 w-600" data-aos="zoom-in">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/sp-hero.png" class="wp-100 position-relative zindex-1">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/hero-icon/sp-hero-male.png" class="w-200 position-absolute zindex-2 t-50 l-272 animation-topdown-3">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/hero-icon/sp-hero-icon1.png" class="w-38 position-absolute zindex-2 b-6 l-42 animation-rotate-1">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/hero-icon/sp-hero-icon1.png" class="w-36 position-absolute zindex-2 t-105 l-213 animation-rotate-1">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/hero-icon/sp-hero-icon5.png" class="w-32 position-absolute zindex-2 t-289 l-160 animation-rotate-2">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/hero-icon/sp-hero-icon5.png" class="w-22 position-absolute zindex-2 t-103 r-20 animation-rotate-2">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/hero-icon/sp-hero-icon6.png" class="w-38 position-absolute zindex-2 b-128 l-243 animation-opacity-1">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/hero-icon/sp-hero-icon4.png" class="w-38 position-absolute zindex-2 t-207 r-10 animation-zoom-2">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/hero-icon/sp-hero-icon8.png" class="w-28 position-absolute zindex-2 b-179 l-227 animation-zoom-1">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/hero-icon/sp-hero-icon3.png" class="w-26 position-absolute zindex-2 t-174 r-100 animation-zoom-1">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/hero-icon/sp-hero-icon2.png" class="w-32 position-absolute zindex-2 b-216 rn-16 animation-rotate-1">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/hero-icon/sp-hero-icon9.png" class="w-95 position-absolute zindex-2 t-176 l-176">
                </div>
            </div>
        </div>
    </div>
</section>

<section class="container p-t-90 p-b-90">
    <div class="row">
        <div class="col-md-4 mb-4">
            <div class="text-center mw-250 mx-auto">
                <div class="fs-50 text-warning font-one fw-6 mb-2"><span class="odometer" data-count-to="289"></span></div>
                <div class="fs-14 text-gray-600"><?php _e("Total Social Media Campaigns completed per month")?></div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="text-center mw-250 mx-auto">
                <div class="fs-50 text-warning font-one fw-6 mb-2"><span class="odometer" data-count-to="2579 "></span></div>
                <div class="fs-14 text-gray-600"><?php _e("Posts are scheduled without interruption every week")?></div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="text-center mw-250 mx-auto">
                <div class="fs-50 text-warning font-one fw-6 mb-2"><span class="odometer" data-count-to="25789 "></span></div>
                <div class="fs-14 text-gray-600"><?php _e("Clients choose platform to build brand through social media")?></div>
            </div>
        </div>
    </div>
</section>

<section class="container sp-top-feature" id="features">
    <div class="row">
        <div class="col-md-5 mb-5">
            <div class="bg-light-warning text-warning d-inline-block fs-12 b-r-10 px-2 py-1 mb-2">
                <?php _e("Feature")?>
            </div>
            <div class="fs-24 fw-6 mb-2">
                <?php _e('Manage social <span class="text-warning">media accounts</span> through one centralized dashboard')?>
            </div>
            <div class="fs-14 mw-450 text-gray-700 mb-4"><?php _e("It is the best solution for Individuals, Small or Large Companies, Software Companies, and Digital Marketers.")?></div>

            <div class="d-flex align-items-center justify-content-left mb-4">
                <div class="bg-light-warning text-gray-700 b-r-10 miw-45 h-45 fs-23 d-flex justify-content-center align-items-center me-3">
                    <i class="fal fa-paper-plane"></i>
                </div>
                <div>
                    <div class="fw-6 mb-1"><?php _e("Composer")?></div>
                    <div class="text-gray-700 fs-12"><?php _e("Create and publish social media content across multiple platforms. Individuals, Small or Large Companies, Software Companies")?></div>
                </div>
            </div>
            <div class="d-flex align-items-center justify-content-left mb-4 p-r-90">
                <div class="bg-light-warning text-gray-700 b-r-10 miw-45 h-45 fs-23 d-flex justify-content-center align-items-center me-3">
                    <i class="fal fa-calendar-check"></i>
                </div>
                <div>
                    <div class="fw-6 mb-1"><?php _e("Schedule Posts")?></div>
                    <div class="text-gray-700 fs-12"><?php _e("Select your date, time or whenever you want to publish on each your social accounts. A few clicks to complete and enjoy.")?></div>
                </div>
            </div>
            <div class="d-flex align-items-center justify-content-left mb-4 p-r-90">
                <div class="bg-light-warning text-gray-700 b-r-10 miw-45 h-45 fs-23 d-flex justify-content-center align-items-center me-3">
                    <i class="fal fa-mail-bulk"></i>
                </div>
                <div>
                    <div class="fw-6 mb-1"><?php _e("Bulk upload multiple posts")?></div>
                    <div class="text-gray-700 fs-12"><?php _e("Save time and effort by scheduling more than a hundred social media posts using our Bulk Uploader in three easy steps.")?></div>
                </div>
            </div>
            <div class="d-flex align-items-center justify-content-left mb-4 p-r-90">
                <div class="bg-light-warning text-gray-700 b-r-10 miw-45 h-45 fs-23 d-flex justify-content-center align-items-center me-3">
                    <i class="fal fa-hand-sparkles"></i>
                </div>
                <div>
                    <div class="fw-6 mb-1"><?php _e("Clear and Concise Dashboard")?></div>
                    <div class="text-gray-700 fs-12"><?php _e("It helps you to quickly and easily understand all your post reports on social media networks")?></div>
                </div>
            </div>
        </div>
        <div class="col-md-7 mb-5">
            <div class="sp-feature-img mw-600 position-relative p-l-30 w-600 mx-auto h-625 overflow-hidden">
                <img src="<?php _ec( get_frontend_url() )?>Assets/images/bg-o1.png" class="w-100 position-absolute zindex-1 tn-100 l-0" data-aos="fade-up">
                <img src="<?php _ec( get_frontend_url() )?>Assets/images/sp-features/f1.png" class="w-200 position-absolute zindex-2 r-35 t-0" data-aos="fade-down">
                <img src="<?php _ec( get_frontend_url() )?>Assets/images/sp-features/f2.png" class="w-450 position-absolute zindex-1 b-0 l-0" data-aos="fade-right">
                <img src="<?php _ec( get_frontend_url() )?>Assets/images/sp-features/f3.png" class="w-450 position-absolute zindex-1 r-0 t-36" data-aos="fade-left">
                <img src="<?php _ec( get_frontend_url() )?>Assets/images/sp-features/f4.png" class="position-absolute zindex-1 t-138 l-0" data-aos="fade-up">
            </div>
        </div>
    </div>
</section>

<section class="container my-5">
    <div class="row align-items-center">
        <div class="col-sm-12 col-md-12 col-lg-3 fs-18 text-center text-md-center text-lg-left mb-4">
            <div><?php _e("Trusted by 20,000+ clients")?></div>
            <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="h-12">
        </div>
        <div class="col-sm-12 col-md-12 col-lg-9 mb-4">
            <div class="w-100 overflow-hidden d-flex align-items-center" id="marquee">
                <ul class="d-flex align-items-center mb-0">
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-1.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-2.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-3.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-4.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-5.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-6.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-7.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-8.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-9.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-10.png">
                    </li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="container sp-benefit">
    
    <div class="mx-auto text-center font-one mb-6 px-5">
        <div class="headline fs-40 fw-6 mb-3 mw-1000 mx-auto text-warning"><?php _e("Maximizing Business Growth with Social Media")?></div>
        <div class="headline-desc fs-18 mw-850 mx-auto text-gray-700"><?php _e("Creating attractive content can be a challenging and time-consuming task. Let us ease the burden by helping you effectively distribute your ideas across all relevant social media channels, ensuring that your content reaches a broader audience.")?></div>
    </div>

    <div class="my-6 mx-auto position-relative">
        <div class="sp-benefit-content mw-550 mx-auto text-center mb-5 w-500 h-500">
            <div class="position-relative w-100 mx-auto t-0 h-100 zindex-2">
                <div class="w-100 h-100 position-absolute t-0 d-none d-lg-block d-md-block d-xs-none">
                    <div class="d-flex align-items-center justify-content-center w-100 h-100 position-absolute t-0 bg-white rounded-circle zindex-2">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/circle-1.png" class="w-100 position-absolute rotating1">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/circle-2.png" class="wp-80 position-absolute rotating2">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/circle-3.png" class="wp-100 position-absolute rotating1">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/circle-4.png" class="wp-80 position-absolute rotating2">
                        <div class="position-absolute w-100 h-100 position-absolute rotating1">
                            <span class="text-gray-800 position-absolute l-38 t-82 fs-24 rotating2"><i class="fal fa-thumbs-up"></i></span>
                            <span class="text-gray-800 position-absolute r-35 t-82 fs-24 rotating2"><i class="fal fa-mug-hot"></i></span>
                            <span class="text-gray-800 position-absolute l-38 b-83 fs-24 rotating2"><i class="fal fa-wreath"></i></span>
                            <span class="text-gray-800 position-absolute r-34 b-85 fs-24 rotating2"><i class="fal fa-cloud"></i></span>
                        </div>

                        <div class="position-absolute wp-80 hp-80 position-absolute rotating2">
                            <span class="text-gray-800 position-absolute r-71 t-21 fs-24 rotating1"><i class="fal fa-comments"></i></span>
                            <span class="text-gray-800 position-absolute l-18 b-75 fs-24 rotating1"><i class="fal fa-calendar-alt"></i></span>
                            <span class="text-gray-800 position-absolute r-32 b-53 fs-24 rotating1"><i class="fal fa-share-square"></i></span>
                        </div>
                    </div>
                </div>
                <div class="w-300 mx-auto d-flex justify-content-center align-items-center h-100 zindex-3 position-relative zindex-3">
                    <div class="owl-carousel sp-slider owl-theme rounded-circle">
                        <div class="item">
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/sp-b1.png" class="w-100 rounded-circle">
                        </div>
                        <div class="item">
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/sp-b2.png" class="w-100 rounded-circle">
                        </div>
                        <div class="item">
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/sp-b3.png" class="w-100 rounded-circle">
                        </div>
                        <div class="item">
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/sp-b4.png" class="w-100 rounded-circle">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="sp-slider-content mx-auto text-center">
            <div class="item">
                <div class="fw-6 fs-25 mb-4 mw-650 mx-auto"><?php _e("Boosting Brand Visibility Through Strategic Social Media Engagement")?></div>
                <div class="fs-14 text-gray-600 mw-850 mx-auto">
                    <?php _e("Maintaining a consistent and strategically planned social media presence significantly enhances your brand’s visibility and recognition, ensuring that your message reaches a wider audience and reinforces your brand identity over time.")?>
                </div>
            </div>
            <div class="item d-none">
                <div class="fw-6 fs-25 mb-4 mw-650 mx-auto"><?php _e("Enhancing Website Traffic Through Effective Social Media Strategies")?></div>
                <div class="fs-14 text-gray-600 mw-850 mx-auto">
                    <?php _e("Effective social media management plays a crucial role in driving increased traffic to your website by strategically placing well-designed links, executing targeted promotions, and creating engaging content.")?>
                </div>
            </div>
            <div class="item d-none">
                <div class="fw-6 fs-25 mb-4 mw-650 mx-auto"><?php _e("Achieving High ROI with Social Media vs. Traditional Advertising")?></div>
                <div class="fs-14 text-gray-600 mw-850 mx-auto">
                    <?php _e("Social media offers a highly cost-effective method for reaching a broad and diverse audience compared to traditional advertising channels, providing businesses with a significantly higher return on investment.")?>
                </div>
            </div>
            <div class="item d-none">
                <div class="fw-6 fs-25 mb-4 mw-650 mx-auto"><?php _e("Strengthening Customer Relationships with Consistent Social Media Presence")?></div>
                <div class="fs-14 text-gray-600 mw-850 mx-auto">
                    <?php _e("By regularly engaging with your audience, sharing valuable content, and consistently representing your brand’s voice, you build trust leading to long-term customer loyalty and a deeper connection with your audience.")?>
                </div>
            </div>
        </div>

        <ul class="circles h-600 w-100 t-0 d-none d-lg-block d-md-block d-xs-none">
            <li class="animation-topdown-5"></li>
            <li class="animation-topdown-6"></li>
            <li class="animation-topdown-5"></li>
            <li class="animation-topdown-6"></li>
            <li class="animation-topdown-5"></li>
            <li class="animation-topdown-6"></li>
            <li class="animation-topdown-5"></li>
            <li class="animation-topdown-6"></li>
            <li class="animation-topdown-5"></li>
            <li class="animation-topdown-6"></li>
            <li class="animation-topdown-5"></li>
            <li class="animation-topdown-6"></li>
            <li class="animation-topdown-5"></li>
            <li class="animation-topdown-6"></li>
            <li class="animation-topdown-5"></li>
            <li class="animation-topdown-6"></li>
            <li class="animation-topdown-5"></li>
        </ul>
    </div>

    <div class="row sp-slider-nav">
        <div class="col-md-3 mb-3">
            <a href="javascript:void(0);" class="bg-light-warning d-block b-r-10 p-20 fw-6 text-gray-800 bg-active-warning" data-index="0">
                <span class="me-2"><i class="fal fa-calendar-plus"></i></span>
                <span><?php _e("Brand Awareness")?></span>
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="javascript:void(0);" class="bg-light-success d-block b-r-10 p-20 fw-6 text-gray-800 bg-active-success" data-index="1">
                <span class="me-2"><i class="fal fa-wreath"></i></span>
                <span><?php _e("Website Traffic")?></span>
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="javascript:void(0);" class="bg-light-primary d-block b-r-10 p-20 fw-6 text-gray-800 bg-active-primary" data-index="2">
                <span class="me-2"><i class="fal fa-users-crown"></i></span>
                <span><?php _e("Cost Efficiency")?></span>
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="javascript:void(0);" class="bg-light-danger  d-block b-r-10 p-20 fw-6 text-gray-800 bg-active-danger" data-index="3">
                <span class="me-2"><i class="fal fa-truck-container"></i></span>
                <span><?php _e("Customer Relationships")?></span>
            </a>
        </div>
    </div>
</section>

<section class="m-t-90">
    <div class="container">
        <div class="mx-auto text-center font-one mb-6 px-5">
            <div class="headline fs-40 fw-6 mb-3 mw-800 mx-auto"><?php _e("Streamline Social Media and Unlock Advanced Features")?></div>
            <div class="headline_desc fs-18 mw-950 mx-auto text-gray-700"><?php _e("Beyond managing your social media accounts from a single location, we offer a suite of advanced features designed to take your social media efforts further.")?></div>
        </div>

        <div>
            <div class="row">
                <div class="col-md-4 mb-4">
                    <div class="b-r-10 bg-gray-100 p-25 pb-0 mb-4 h-100">
                        <div class="w-40 h-40 b-r-10 border d-flex justify-content-center align-items-center mb-3 text-gray-800 fs-22 bg-light-warning"><i class="fal fa-file-edit"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Save and edit drafts")?></div>
                        <div class="text-gray-700"><?php _e("Keep your content ideas safe by saving drafts from the Composer whenever you want, enabling you to perfect and publish them later.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="b-r-10 bg-gray-100 p-25 pb-0 mb-4 h-100">
                        <div class="w-40 h-40 b-r-10 border d-flex justify-content-center align-items-center mb-3 text-gray-800 fs-22 bg-light-warning"><i class="fal fa-comment-alt-lines"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Save & Get Caption")?></div>
                        <div class="text-gray-700"><?php _e("Save your content with Captions Feature that you plan to use repetitively in your social media posts that you regularly use are particularly good to be saved as captions. Sometimes, you can organize your hashtags, and links and then get them when you compose a new post.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="b-r-10 bg-gray-100 p-25 pb-0 mb-4 h-100">
                        <div class="w-40 h-40 b-r-10 border d-flex justify-content-center align-items-center mb-3 text-gray-800 fs-22 bg-light-warning"><i class="fal fa-user-circle"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Account Manager")?></div>
                        <div class="text-gray-700"><?php _e("Save time on social media by connecting your accounts to the platform. With us, you can manage activity for all your linked accounts in one place, removing the need to sign in to each social network individually.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="b-r-10 bg-gray-100 p-25 pb-0 mb-4 h-100">
                        <div class="w-40 h-40 b-r-10 border d-flex justify-content-center align-items-center mb-3 text-gray-800 fs-22 bg-light-warning"><i class="fal fa-folder-open"></i></div>
                        <div class="fw-6 mb-1"><?php _e("File Manager")?></div>
                        <div class="text-gray-700"><?php _e("With the file manager, you can create and view the files/folders hierarchy and access a range of functions like uploading, moving, as well as deleting files, and folders.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="b-r-10 bg-gray-100 p-25 pb-0 mb-4 h-100">
                        <div class="w-40 h-40 b-r-10 border d-flex justify-content-center align-items-center mb-3 text-gray-800 fs-22 bg-light-warning"><i class="fal fa-wreath"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Watermark")?></div>
                        <div class="text-gray-700"><?php _e("A watermark is a visible overlay that is applied to an image that is placed in a prominent location on the media file, such as the corner or centre.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="b-r-10 bg-gray-100 p-25 pb-0 mb-4 h-100">
                        <div class="w-40 h-40 b-r-10 border d-flex justify-content-center align-items-center mb-3 text-gray-800 fs-22 bg-light-warning"><i class="fal fa-image-polaroid"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Photo Editor")?></div>
                        <div class="text-gray-700"><?php _e("Produce attention-grabbing, remarkable, shareable, and stunning images with Image Editor which is integrated with our platform. You can edit and enhance your photo before publishing it to your selected network.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="b-r-10 bg-gray-100 p-25 pb-0 mb-4 h-100">
                        <div class="w-40 h-40 b-r-10 border d-flex justify-content-center align-items-center mb-3 text-gray-800 fs-22 bg-light-warning"><i class="fal fa-mail-bulk"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Social Media Post Types")?></div>
                        <div class="text-gray-700"><?php _e("There are several types of posts that can be created on our platform such as Images, Videos, Links and text and we are constantly evolving, and new features and post types are added regularly.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="b-r-10 bg-gray-100 p-25 pb-0 mb-4 h-100">
                        <div class="w-40 h-40 b-r-10 border d-flex justify-content-center align-items-center mb-3 text-gray-800 fs-22 bg-light-warning"><i class="fal fa-link"></i></div>
                        <div class="fw-6 mb-1"><?php _e("URL Shortener")?></div>
                        <div class="text-gray-700"><?php _e("Shortening URLs becomes essential when you have to share long and complicated web links on social media platforms that have character limitations.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="b-r-10 bg-gray-100 p-25 pb-0 mb-4 h-100">
                        <div class="w-40 h-40 b-r-10 border d-flex justify-content-center align-items-center mb-3 text-gray-800 fs-22 bg-light-warning"><i class="fal fa-brackets-curly"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Spintax")?></div>
                        <div class="text-gray-700"><?php _e("It’s an ideal tool to create massive content. It could minimize the risk of account lockouts if social media platforms tag the messages as spam.")?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="sp-get-started m-t-90">
    <div class="container bg-warning b-r-30 p-t-90 p-b-90 text-white">
        <div class="row mx-auto font-one px-5">
            <div class="col-md-5 offset-md-1 mb-3 mt-3 text-center text-md-left text-sm-center text-xs-left fs-20"><?php _e("Take advantage of our free trial offer today, with no commitments or credit card required.")?></div>
            <div class="col-md-5 mb-3 mt-3">
                <div class="d-flex justify-content-center">
                    <div><a class="btn btn-dark" href="<?php _ec( base_url("login") )?>"><?php _e("Get started for Free")?></a></div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="sp-rating p-t-90 p-b-90">

    <div class="container">
        <div class="mx-auto text-center font-one mb-6 px-5">
            <div class="headline fs-40 fw-6 mb-3 mw-900 mx-auto"><?php _e("What <span class='text-warning'>our clients</span> say", 0)?></div>
            <div class="headline_desc fs-18 mw-650 mx-auto text-gray-700"><?php _e("We receive high praise from our clients for our outstanding results, approachable service. Take a look at what some of them have to say.")?></div>
        </div>

        <div class="position-relative">
            <div class="py-3 position-relative mw-1000 mx-auto">
                <div class="mw-550 mx-auto text-center position-relative mx-auto zindex-2">
                    <div class="owl-carousel rating-slider owl-theme">
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("Complete Tool for Social Media Agencies")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("It's amazing to have found a tool that integrates all the necessary resources for a Social Media Marketing agency into one comprehensive and accessible platform.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/1.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("John Carter")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("Digital Marketing Manager")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("Efficient Marketing Management and Expanded Presence")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("With this platform, I can efficiently manage my marketing efforts, reduce the time spent on tasks, and expand my presence in multiple locations effortlessly.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/2.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("Emma Grace")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("SEO Specialist")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("Comprehensive Analytics and Impressive Post Management")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("I really appreciate this platform for its comprehensive analytics, ability to schedule in bulk, versatile scheduling options, and impressive post appearance.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/3.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("Liam Scott")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("Social Media Strategist")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("One Hour a Week, Zero Social Media Worries")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("It’s fantastic to spend just an hour each week adding to my library and then not have to worry about social media for the rest of the week.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/4.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("Ava Rose")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("Social Media Analyst")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("Doubling Growth and 68% More Productivity")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("Thanks to this tool, our company has grown doubled. Without it, we would have been floundering, but now we’re accomplishing 68% more work with the same team.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/5.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("Noah James")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("Content Manager")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("Easy Scheduling and Metrics with the team")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("This incredible platform has unified our team. It offers easy post scheduling, smooth team collaboration, and centralized metric sharing with all stakeholders, all in one convenient place.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/6.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("Olivia Claire")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("Marketing Automation Specialist")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <ul class="position-absolute w-100 h-100 t-0 rating-slider-nav d-none d-lg-block d-md-block d-xs-none">
                    <li class="rounded-circle border-dashed border-warning p-1  w-60 h-60 position-absolute l-70 t-30 bg-active-warning active" data-index="0">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/1.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                    <li class="rounded-circle border-dashed border-warning p-1  w-95 h-95 position-absolute l-0 t-220 bg-active-warning" data-index="1">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/2.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                    <li class="rounded-circle border-dashed border-warning p-1  w-74 h-74 position-absolute l-70 b-30 bg-active-warning" data-index="2">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/3.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                    <li class="rounded-circle border-dashed border-warning p-1  w-74 h-74 position-absolute r-70  t-30 bg-active-warning" data-index="3">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/4.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                    <li class="rounded-circle border-dashed border-warning p-1  w-95 h-95 position-absolute r-0 t-220 bg-active-warning" data-index="4">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/5.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                    <li class="rounded-circle border-dashed border-warning p-1  w-74 h-74 position-absolute r-70 b-40 bg-active-warning" data-index="5">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/6.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

</section>

<section class="bg-gray-100 p-t-150 p-b-150 position-relative overflow-hidden">
    <img src="<?php _ec( get_frontend_url() )?>Assets/images/shape-1.png" class="position-absolute ln-120 tn-200 mw-600 opacity-50">
    <img src="<?php _ec( get_frontend_url() )?>Assets/images/shape-2.png" class="position-absolute rn-120 bn-200 mw-600 opacity-25">
    <div class="mx-auto container text-center position-relative zindex-1">
        <div class="fs-40 fw-9 mb-4">
            <?php _e("Join 5,000 happy customers like you who trust us to help them manage their social media calendars.")?>
        </div>
        <div class="fs-16 text-gray-700 mb-4"><?php _e("You can get started in mere minutes.")?></div>
        <a class="btn btn-dark" href="<?php _ec( base_url("login") )?>"><?php _e("Sign up for Free")?></a>
    </div>
</section>