<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Pink color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface PinkColorProviderInterface extends ColorProviderInterface {

    /**
     * Pink color "100"
     *
     * @var string
     */
    const PINK_COLOR_100 = "#F8BBD0";

    /**
     * Pink color "200"
     *
     * @var string
     */
    const PINK_COLOR_200 = "#F48FB1";

    /**
     * Pink color "300"
     *
     * @var string
     */
    const PINK_COLOR_300 = "#F06292";

    /**
     * Pink color "400"
     *
     * @var string
     */
    const PINK_COLOR_400 = "#EC407A";

    /**
     * Pink color "50"
     *
     * @var string
     */
    const PINK_COLOR_50 = "#FCE4EC";

    /**
     * Pink color "500"
     *
     * @var string
     */
    const PINK_COLOR_500 = "#E91E63";

    /**
     * Pink color "600"
     *
     * @var string
     */
    const PINK_COLOR_600 = "#D81B60";

    /**
     * Pink color "700"
     *
     * @var string
     */
    const PINK_COLOR_700 = "#C2185B";

    /**
     * Pink color "800"
     *
     * @var string
     */
    const PINK_COLOR_800 = "#AD1457";

    /**
     * Pink color "900"
     *
     * @var string
     */
    const PINK_COLOR_900 = "#880E4F";

    /**
     * Pink color "A100"
     *
     * @var string
     */
    const PINK_COLOR_A100 = "#FF80AB";

    /**
     * Pink color "A200"
     *
     * @var string
     */
    const PINK_COLOR_A200 = "#FF4081";

    /**
     * Pink color "A400"
     *
     * @var string
     */
    const PINK_COLOR_A400 = "#F50057";

    /**
     * Pink color "A700"
     *
     * @var string
     */
    const PINK_COLOR_A700 = "#C51162";

    /**
     * Pink color name.
     *
     * @var string
     */
    const PINK_COLOR_NAME = "pink";
}
