<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Light blue color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface LightBlueColorProviderInterface extends ColorProviderInterface {

    /**
     * Light blue color "100"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_100 = "#B3E5FC";

    /**
     * Light blue color "200"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_200 = "#81D4FA";

    /**
     * Light blue color "300"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_300 = "#4FC3F7";

    /**
     * Light blue color "400"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_400 = "#29B6F6";

    /**
     * Light blue color "50"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_50 = "#E1F5FE";

    /**
     * Light blue color "500"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_500 = "#03A9F4";

    /**
     * Light blue color "600"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_600 = "#039BE5";

    /**
     * Light blue color "700"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_700 = "#0288D1";

    /**
     * Light blue color "800"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_800 = "#0277BD";

    /**
     * Light blue color "900"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_900 = "#01579B";

    /**
     * Light blue color "A100"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_A100 = "#80D8FF";

    /**
     * Light blue color "A200"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_A200 = "#40C4FF";

    /**
     * Light blue color "A400"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_A400 = "#00B0FF";

    /**
     * Light blue color "A700"
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_A700 = "#0091EA";

    /**
     * Light blue color name.
     *
     * @var string
     */
    const LIGHT_BLUE_COLOR_NAME = "light-blue";
}
