<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Indigo color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface IndigoColorProviderInterface extends ColorProviderInterface {

    /**
     * Indigo color "100"
     *
     * @var string
     */
    const INDIGO_COLOR_100 = "#C5CAE9";

    /**
     * Indigo color "200"
     *
     * @var string
     */
    const INDIGO_COLOR_200 = "#9FA8DA";

    /**
     * Indigo color "300"
     *
     * @var string
     */
    const INDIGO_COLOR_300 = "#7986CB";

    /**
     * Indigo color "400"
     *
     * @var string
     */
    const INDIGO_COLOR_400 = "#5C6BC0";

    /**
     * Indigo color "50"
     *
     * @var string
     */
    const INDIGO_COLOR_50 = "#E8EAF6";

    /**
     * Indigo color "500"
     *
     * @var string
     */
    const INDIGO_COLOR_500 = "#3F51B5";

    /**
     * Indigo color "600"
     *
     * @var string
     */
    const INDIGO_COLOR_600 = "#3949AB";

    /**
     * Indigo color "700"
     *
     * @var string
     */
    const INDIGO_COLOR_700 = "#303F9F";

    /**
     * Indigo color "800"
     *
     * @var string
     */
    const INDIGO_COLOR_800 = "#283593";

    /**
     * Indigo color "900"
     *
     * @var string
     */
    const INDIGO_COLOR_900 = "#1A237E";

    /**
     * Indigo color "A100"
     *
     * @var string
     */
    const INDIGO_COLOR_A100 = "#8C9EFF";

    /**
     * Indigo color "A200"
     *
     * @var string
     */
    const INDIGO_COLOR_A200 = "#536DFE";

    /**
     * Indigo color "A400"
     *
     * @var string
     */
    const INDIGO_COLOR_A400 = "#3D5AFE";

    /**
     * Indigo color "A700"
     *
     * @var string
     */
    const INDIGO_COLOR_A700 = "#304FFE";

    /**
     * Indigo color name.
     *
     * @var string
     */
    const INDIGO_COLOR_NAME = "indigo";
}
