<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Deep orange color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface DeepOrangeColorProviderInterface extends ColorProviderInterface {

    /**
     * Deep orange color "100"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_100 = "#FFCCBC";

    /**
     * Deep orange color "200"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_200 = "#FFAB91";

    /**
     * Deep orange color "300"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_300 = "#FF8A65";

    /**
     * Deep orange color "400"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_400 = "#FF7043";

    /**
     * Deep orange color "50"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_50 = "#FBE9E7";

    /**
     * Deep orange color "500"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_500 = "#FF5722";

    /**
     * Deep orange color "600"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_600 = "#F4511E";

    /**
     * Deep orange color "700"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_700 = "#E64A19";

    /**
     * Deep orange color "800"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_800 = "#D84315";

    /**
     * Deep orange color "900"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_900 = "#BF360C";

    /**
     * Deep orange color "A100"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_A100 = "#FF9E80";

    /**
     * Deep orange color "A200"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_A200 = "#FF6E40";

    /**
     * Deep orange color "A400"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_A400 = "#FF3D00";

    /**
     * Deep orange color "A700"
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_A700 = "#DD2C00";

    /**
     * Deep orange color name.
     *
     * @var string
     */
    const DEEP_ORANGE_COLOR_NAME = "deep-orange";
}
