<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Cyan color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface CyanColorProviderInterface extends ColorProviderInterface {

    /**
     * Cyan color "100"
     *
     * @var string
     */
    const CYAN_COLOR_100 = "#B2EBF2";

    /**
     * Cyan color "200"
     *
     * @var string
     */
    const CYAN_COLOR_200 = "#80DEEA";

    /**
     * Cyan color "300"
     *
     * @var string
     */
    const CYAN_COLOR_300 = "#4DD0E1";

    /**
     * Cyan color "400"
     *
     * @var string
     */
    const CYAN_COLOR_400 = "#26C6DA";

    /**
     * Cyan color "50"
     *
     * @var string
     */
    const CYAN_COLOR_50 = "#E0F7FA";

    /**
     * Cyan color "500"
     *
     * @var string
     */
    const CYAN_COLOR_500 = "#00BCD4";

    /**
     * Cyan color "600"
     *
     * @var string
     */
    const CYAN_COLOR_600 = "#00ACC1";

    /**
     * Cyan color "700"
     *
     * @var string
     */
    const CYAN_COLOR_700 = "#0097A7";

    /**
     * Cyan color "800"
     *
     * @var string
     */
    const CYAN_COLOR_800 = "#00838F";

    /**
     * Cyan color "900"
     *
     * @var string
     */
    const CYAN_COLOR_900 = "#006064";

    /**
     * Cyan color "A100"
     *
     * @var string
     */
    const CYAN_COLOR_A100 = "#84FFFF";

    /**
     * Cyan color "A200"
     *
     * @var string
     */
    const CYAN_COLOR_A200 = "#18FFFF";

    /**
     * Cyan color "A400"
     *
     * @var string
     */
    const CYAN_COLOR_A400 = "#00E5FF";

    /**
     * Cyan color "A700"
     *
     * @var string
     */
    const CYAN_COLOR_A700 = "#00B8D4";

    /**
     * Cyan color name.
     *
     * @var string
     */
    const CYAN_COLOR_NAME = "cyan";
}
